<?php

namespace App;

use SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class AppUserAuthorization extends Model
{
    use SoftDeletes;
    
    /**
     * Overwrite created_by field value with currently logged in user.
     * Set @var has_created_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */
    protected $has_created_by = false;

    /**
     * Overwrite updated_by field value with currently logged in user.
     * Set @var has_updated_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */

    protected $has_updated_by = false;

    /**
     * Define fields name which have html tags
     * Set @var notStripTags add DB Table column name which column have html tags.
     *
     * @var array
     */
    public static $notStripTags = [];
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'oauth_access_token_id',
        'access_token',
        'refresh_token',
        'device_id',
        'device_token',
        'device_type',
        'device_brand',
        'device_name',
        'device_version',
        'app_version',
        'api_version'
    ];
}
