<?php

namespace App;

use App\Model;
use Auth;

class Bar extends Model
{
    /**
     * Overwrite created_by field value with currently logged in user.
     * Set @var has_created_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */
    protected $has_created_by = true;

    /**
     * Overwrite updated_by field value with currently logged in user.
     * Set @var has_updated_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */

    protected $has_updated_by = true;

    /**
     * Define feilds name which have html tags
     * Set @var notStripTags add DB Table column name which column have html tags.
     *
     * @var array
     */

    public static $notStripTags = [];


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'state_name',
        'state_id',
        'voluntary_bar',
        'cle_mandatory',
        'hours_needed_per_cycle',
        'cycle_length',
        'general',
        'ethics',
        'podcast_accepted',
        'shortest_length_accepted',
        'credit_upload_method',
        'auto_credit_upload',
        'stripe_product_id',
        'annual_price_stripe_price_id',
        'surcharge_fees_stripe_price_id',
        'submission_fees_stripe_price_id',
        'status',
        'created_by',
        'updated_by'
    ];

    public function users()
    {
        return $this->hasMany('App\BarUserReference', 'bar_id', 'id')->where('is_paid',1);
    }

    public function contentsStates()
    {
        return $this->hasMany('App\ContentsStates', 'bar_id', 'id');
    }

    /**
     * The get result based on search criteria.
     * @param  \Illuminate\Http\Request  $request
     * @return object App\Bar
     */
    public function getResult($request)
    {
        // Set default parameter values
        $order_by = !empty($request->get('order_by')) ? $request->get('order_by') : 'id';
        $order = !empty($request->get('order')) ? $request->get('order') : 'asc';
        $defaultper_bar = !empty($request->get('per_page')) ? $request->get('per_page') : siteconfig('records_per_page', 0);

        // Fetch bars list
        $bars = new Bar;

        // Search
        if (!empty($request->get('search'))) {
            $searchStr = $request->get('search');
            $escape = "ESCAPE '|'";
            if (substr_count($searchStr, "|")) {
                $searchStr = str_replace('\\', '\\\\\\', $searchStr);
                $escape = "";
            }
            // added escape for searching backslash issue DLC-140
            $bars = $bars->where(function ($query) use ($searchStr, $escape) {
                $query
                    ->whereRaw('state_name LIKE ?  ' . $escape, '%' . $searchStr . '%');
            });
        }

        // Status
        if ($request->get('status') !== null) {
            $bars = $bars->where('status', $request->get('status'));
        }
        //if per_bar not set then all record value use for per_bar
        // Curretly it is not in Admin user listing as we are using data table paging
        // but have kept this for API integration
        $per_bar = !empty($defaultper_bar) ? $defaultper_bar : $bars->count();

        // Order By & Pagination
        $bars = $bars->orderBy($order_by, $order)->paginate($per_bar);

        return $bars;
    }
}
