<?php

namespace App;

use Illuminate\Database\Eloquent\Model as Model ;
use App\Traits\DbEvents;
use Illuminate\Support\Facades\DB;
use Auth;
use App\User;


class BarUserReference extends Model
{
    use DbEvents;
    /**
     * Overwrite created_by field value with currently logged in user.
     * Set @var has_created_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */
    protected $has_created_by = true;

    /**
     * Overwrite updated_by field value with currently logged in user.
     * Set @var has_updated_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */

    protected $has_updated_by = true;

    /**
     * Define feilds name which have html tags
     * Set @var notStripTags add DB Table column name which column have html tags.
     *
     * @var array
     */

    public static $notStripTags = [];


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'bar_id',
        'bar_number',
        'is_paid',
        'paid_by',
        'created_by',
        'updated_by'
    ];

    public function bar()
    {
        return $this->hasOne('App\Bar', 'id', 'bar_id');
    }

    //not in use commented by Nirmal incase of need to use we can check 23-04-2024
    // public function saveReference($data){
    //     $entryExist = BarUserReference::where('user_id', $data['user_id'])->where('bar_id',$data['bar_id'])->first();
    //     if(isset($entryExist) && !empty($entryExist)){
    //         $entryExist->fill($data);
    //         $entryExist->save();
    //         return  'Bar updated successfully with your user.';
    //     }
    //     else{
    //         $ref = new BarUserReference;
    //         $ref->fill($data);
    //         $ref->save();
    //         return  'Bar added successfully with your user.';
    //     }
    // }

    //not in use commented by Nirmal incase of need to use we can check 23-04-2024
    // public function deleteReference($data){
    //     $entryExist = BarUserReference::where('user_id', $data['user_id'])->where('bar_id',$data['bar_id'])->first();
    //     if(isset($entryExist) && !empty($entryExist)){
    //         $entryExist->delete();
    //     }
    // }

}
