<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\ActivityLog;
use App\ActivityLogArchive;
use Carbon\Carbon;

class ActivityLogArchiveCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'archive:activitylogs';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Archive Activity Log';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        ini_set('max_execution_time', '0');

        $pastDays = siteconfig('archive_days');
		
        $activityLogs = ActivityLog ::where( 'created_at', '<', Carbon::now()->subDays($pastDays))->orderBy('created_at', 'asc')->get();
		
        if(!empty($activityLogs) && isset($activityLogs)){
            
            foreach($activityLogs as $activityLog){
				$allarchive = [];
                $insertrecord = new ActivityLogArchive();
                $insertrecord->session_id = $activityLog->session_id;
                $insertrecord->user_id = $activityLog->user_id;
                $insertrecord->model = $activityLog->model;
                $insertrecord->activity = $activityLog->activity;
                $insertrecord->pk_id = $activityLog->pk_id;
                $insertrecord->data = $activityLog->data;
                $insertrecord->ip_address = $activityLog->ip_address;
				$insertrecord->created_at = $activityLog->created_at;
                $insertrecord->archive_date = Carbon::now()->format(config('app.db_date_time_long_format'));
                $allarchive = $insertrecord->attributesToArray();
	
				ActivityLogArchive::create($allarchive); 
                ActivityLog::where('id',$activityLog->id)->delete();
            }
        }
        //restore data 
        $lastActivityLogs = ActivityLog::orderBy('created_at', 'asc')->limit(1)->get();
          
        if($lastActivityLogs[0]->created_at >= Carbon::now()->subDays($pastDays)->format(config('app.db_date_time_long_format'))){
            $archiveActivityLogs = ActivityLogArchive::where( 'created_at', '<', $lastActivityLogs[0]->created_at)->where( 'created_at', '>=', Carbon::now()->subDays($pastDays))->orderBy('created_at', 'asc')->get();
            if(!empty($archiveActivityLogs) && isset($archiveActivityLogs)){
        
                foreach($archiveActivityLogs as $activity){
                    $insertrecord = new ActivityLog();
                    $insertrecord->session_id = $activity->session_id;
                    $insertrecord->user_id = $activity->user_id;
                    $insertrecord->model = $activity->model;
                    $insertrecord->activity = $activity->activity;
                    $insertrecord->pk_id = $activity->pk_id;
                    $insertrecord->data = $activity->data;
                    $insertrecord->ip_address = $activity->ip_address;
                    $insertrecord->created_at = $activity->created_at;
					$insertrecord->save();
                    sleep(20);
                    ActivityLogArchive::where('id',$activity->id)->delete();
                }
            }
        }

        $this->info('Succesfully archived activity logs');
    }

    
}
