<?php

namespace App\Console\Commands;

use App\Content;
use App\UserCredits;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class DeleteUserCredits extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:delete-expired-user-credits';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $today = Carbon::now()->toDateString();
        $contents = Content::where('expire_date','<', $today)->get();
        foreach ($contents as $content) {
            $userCredits = $content->getUserCredits($content->id);
            foreach ($userCredits as $userCredit) {
                UserCredits::destroy($userCredit->id);
            }
        }
    }
}
