<?php

namespace App\Console\Commands;

use App\Content;
use App\ContentFiles;
use App\UserCredits;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;

class GenerateCrc32ForContent extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'admin:generate-crc32-for-content';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Add content crc32 code to existing episodes';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $contentFiles = Content::where('title_crc32',null)->get();
        foreach ($contentFiles as $file) {
            $file->update(['title_crc32' => crc32_encode($file->podcast_title)]);     
        }
    }
}

