<?php

namespace App\Console\Commands;

use App\Content;
use App\ContentFiles;
use App\UserCredits;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\View;

class GenerateRssDaily extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'generate:rss-for-content';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Add content rss file daily';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $rss = Cache::remember('rss.feed', now()->addDay(), function () {
        $contents = Content::latest('created_at')->take(50)->get();
        $rssContent = View::make('feed.rss', compact('contents'))->render();

            // Save RSS file to public/rss.xml
            file_put_contents(public_path('rss.xml'), $rssContent);

            return $rssContent;
        });

        $this->info('RSS feed generated and cached.');
    }
}
