<?php

namespace App\Console\Commands;

use App\Subscription;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class GetPromocodeForExistingUser extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'store:get-promocode-for-existing-users';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get promocode for exisiting users through stripe.';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $subscriptions = Subscription::all();
        $subscriptionsWithPromo = [];

        foreach ($subscriptions as $subscription) {
            try {
                $stripeSubscription = retrieveStripeSubscription($subscription->subscription_id);
                $couponcode = $stripeSubscription->discount->coupon->name ?? null;

                if($couponcode != null){
                    $promocodeData = retrieveStripePromocode($stripeSubscription->discount->promotion_code);
                    $promocode = $promocodeData->code;
                    $subscriptionsWithPromo[] = [
                        'subscription_id' => $subscription->id,
                        'stripe_subscription_id' => $subscription->subscription_id,
                        'couponcode' => $couponcode,
                        'promocode'=>$promocode
                    ];

                    $subscription->update(['couponcode'=>$couponcode, 'promocode'=>$promocode]);
                }
            } catch (\Exception $e) {
                // Log::error("Error fetching subscription {$subscription->subscription_id}: " . $e->getMessage());
            }
        }

        // Log::info('subscriptions with promocode',[$subscriptionsWithPromo]);
     
    }
}
