<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;

class MediaRegenerateThumbnail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'media:regenerate-thumbnail';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Regenerate Image Thumbnail';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        ini_set('max_execution_time', '0');

        $folder = $this->ask('Enter directory name for which thumbnails will be regenerated?');
        if(empty($folder)) {
            $this->error('Enter directory name');
            return;
        }

        $visibility = getMediaVisibility(config('image-sizes.'.$folder.'.visibility'));
        $images = Storage::files($folder);
        if(!empty($images)) {
            foreach($images as $image) {
                if(!in_array(Storage::mimeType($image), ['image/png','image/jpeg', 'image/jpg', 'image/gif'])){
                    continue;
                }

                $file_name = str_replace($folder.'/', '', $image);
                if(count(explode('-',$file_name)) < 2) {
                    $image_contents = Storage::get($image);
                    foreach (config('image-sizes.'.$folder.'.sizes', []) as $prefix => $image) {
                        $this->resizeImageContent($image_contents,$image,$prefix,$file_name,$folder,$visibility);
                    }
                }
            }
        }

        $this->info('Thumbnails generated successfully for '.$folder.' directory!');
    }

    private function resizeImageContent($image_contents,$image,$prefix,$file_name,$folder,$visibility){
        
        $resizeFile = Image::make($image_contents);
        switch ($image['method']) {
            case 'crop': {
                $resizeFile->fit($image['width'], $image['height'])->crop($image['width'], $image['height']);
                break;
            }
            case 'fit':
            default:
                {
                $resizeFile->resize($image['width'], $image['height'], function ($constraint) {
                    $constraint->aspectRatio();
                });
                break;
            }
        }
        $resizeFile->encode(null, config('image.quality'));
        Storage::put($folder."/".$prefix.'-'.$file_name, (string) $resizeFile, $visibility);
        $this->info($folder."/".$prefix.'-'.$file_name);
    }
}
