<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Http\File;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;

class MediaSetVisibility extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'media:update-visibility {--visibility=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update Media Visibility';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        ini_set('max_execution_time', '0');

        if(!in_array($this->option('visibility'), ['public','private']) || $this->option('visibility') != getMediaVisibility($this->option('visibility'))) {
            $this->error('--visibility parameter value is incorrect.');
            return;
        }

        $folder = $this->ask('Enter directory name for which visibility will be updated?');
        if(empty($folder)) {
            $this->error('Enter directory name');
            return;
        }

        $visibility = $this->option('visibility');
        $medias = Storage::files($folder);
        if(!empty($medias)) {
            foreach($medias as $media) {
                if($visibility != Storage::getVisibility($media)) {
                    Storage::setVisibility($media, $visibility);
                    $this->info($media);
                }
            }
        }

        $this->info('Visibility updated successfully for '.$folder.' directory!');
    }
}
