<?php

namespace App\Console\Commands;

use App\BarUserReference;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class PoadcastAccessLimitCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'poadcastaccesslimit:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        // Calculate the date and time 48 hours ago
        $thresholdDate = Carbon::now()->subHours(48);

        // Delete records older than the threshold date
        BarUserReference::whereDate('created_at', '<', $thresholdDate)->where('is_paid',0)->delete();
    }
}
