<?php

namespace App\Console\Commands;
use App\User;
use App\Notifications\SendBetaUsersTestingEmail;
use Illuminate\Console\Command;
use App\SiteConfig;
use Carbon\Carbon;

class SendBetaTestingEmail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'send:beta-testing-email';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send email to beta user for testing';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $accessToken = SiteConfig::where('name', 'mail_access_token')->first();
        if (isset($accessToken)) {
            config([
                'mail.from.address' => siteconfig('from_email'),
                'mail.from.name' => siteconfig('from_name'),
                'mail.password' => $accessToken->val,
            ]);
        }

        // //Send email
        // $userArray = [];
        // if(env('APP_ENV_CODE') == "development"){
        //     $userArray = [
        //         ['name' => 'Emily Moore Leininger', 'email' => 'emily.moore@hotmail.com'],
        //         ['name' => 'Aaron Walsh', 'email' => 'aaronwalsh@walshlaw.biz'],
        //         ['name' => 'Taylor Rippe', 'email' => 'taylor@nashvillefamilylaw.com'],
        //         ['name' => 'Demi Marks', 'email' => 'Demi@mccracken.law'],
        //         ['name' => 'Jim Widrig', 'email' => 'Attorney@WidrigLaw.com'],
        //         ['name' => 'Erin King', 'email' => 'assistant@kingandcagle.com'],
        //         ['name' => 'David Grimmett', 'email' => 'David@davewins.com'],
        //         ['name' => 'Peggy Smith Pulley', 'email' => 'peggy@psplaw.net'],
        //         ['name' => 'David L. King', 'email' => 'dking271@united.net'],
        //         ['name' => 'Ryan Davis', 'email' => 'ryan@ryancdavislaw.com'],
        //         ['name' => 'Joanna Lee McCracken', 'email' => 'joanna@mccracken.law'],
        //         ['name' => 'Gabrielle Mees Logston', 'email' => 'GLogston@gsrm.com'],
        //         ['name' => 'Ryan Johnson', 'email' => 'ryan@jryanjohnson.law'],
        //         ['name' => 'Robb Turner', 'email' => 'rob@nashvillelawoffices.com'],
        //         ['name' => 'Nirmal Patel', 'email' => 'nirmal.patel+prod@kernelequity.com'],
        //         ['name' => 'Rahul Upadhyay', 'email' => 'rahul+prod@kernelequity.com'],
        //         ['name' => 'Kernel Equity', 'email' => 'support@kernelequity.com'],
        //     ];
        // }else{
        //     $userArray = [
        //         [
        //             'name' => 'Nirmal Patel',
        //             'email' => 'nirmal.patel@kernelequity.com'
        //         ]
        //     ];
        // }
        $userArray = [
            [
                'name' => 'Nirmal Patel',
                'email' => 'nirmal.patel@kernelequity.com'
            ],
            [
                'name' => 'Rahul Upadhyay',
                'email' => 'rahul@kernelequity.com'
            ],
            [
                'name' => 'Ryan Davis',
                'email' => 'ryan@ryancdavislaw.com'
            ]
        ];
        $currentDate = Carbon::now();
        $desiredDate = Carbon::parse('2024-10-15');

        if ($currentDate->isSameDay($desiredDate)) {
            foreach ($userArray as $userData) {
                $user = User::make(['email' => $userData['email']]);
                if ($user) {
                    $user->notify(new SendBetaUsersTestingEmail($userData['name']));
                } else {
                    $this->warn("User with email not found.");
                }
            }
        }

    }
}
