<?php

namespace App\Console\Commands;
use App\User;
use App\Submissions;
use App\Exports\SubmissionExport;
use App\Notifications\SendSubmissionReports;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Storage;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Notification;
use stdClass;
use Illuminate\Support\Facades\Log;
use App\SiteConfig;

class SendDailyExcel extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'send:daily-excel';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send daily excel report via email';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $accessToken = SiteConfig::where('name', 'mail_access_token')->first();
        if (isset($accessToken)) {
            config([
                'mail.from.address' => siteconfig('from_email'),
                'mail.from.name' => siteconfig('from_name'),
                'mail.password' => $accessToken->val,
            ]);
        }


        $submissionModel = new Submissions;
        $submissions = $submissionModel->getReportData();
        $submissionsCount = $submissionModel->getReportDataCount();
        $submissionsSum = $submissionModel->getReportDataSum();
        // Log::info('submissionsSum',[$submissionsSum]);

        //calculate hours spnet by each user for the credits 

    $userHoursData = [];

    foreach ($submissions as $submission) {
        $userId = $submission->user_id;

        if (!isset($userHoursData[$userId])) {
            $userHoursData[$userId] = [
                'user_name' => $submission->user_name,
                'total_credits' => 0,
                'bars' => []
            ];
        }

        $userHoursData[$userId]['total_credits'] += $submission->credits_submitted;

        $bars = getBarsOfUser($userId);

        foreach ($bars as $bar) {
            $barId = $bar->bar_id;
            $intervalMinutes = $bar->hours;

            if (!isset($userHoursData[$userId]['bars'][$barId])) {
                $userHoursData[$userId]['bars'][$barId] = [
                    'state_name' => $bar->state_name,
                    'hours_needed_per_cycle' => $intervalMinutes,
                    'hours_spent' => 0
                ];
            }


            $totalMinutes = ($userHoursData[$userId]['total_credits'] / 0.25) * $intervalMinutes;
            $userHoursData[$userId]['bars'][$barId]['hours_spent'] = round($totalMinutes / 60, 2);
        }
    }

        $export = new SubmissionExport(collect($submissions)); // Convert array to collection
        $today = Carbon::now()->toDateString();

        ini_set('max_execution_time', '0');
        $folder = 'upload_file';
        $visibility = getMediaVisibility();
        $file_name = 'daily_report-' . $today . '.xlsx';

        // Store the Excel file
        $path = $folder . '/' . $file_name;
        Excel::store($export, $path, null, \Maatwebsite\Excel\Excel::XLSX);

        $storage_file_url = getMediaUrl($path, $visibility);
        // Send email
        $emails = siteconfig('submission_reports_email');
        if (!empty($emails)) {
            $emailsArray = explode(',', $emails);
            foreach ($emailsArray as $email) {
                // $user = User::make(['email' => $email]);;
                // if ($user) {
                //     $user->notify(new SendSubmissionReports($submissionsCount));
                // } else {
                //     $this->warn("User with email $email not found.");
                // }
                Notification::route('mail', $email)
                ->notify(new SendSubmissionReports($submissionsCount, $userHoursData));
            }
        }
    }
}
