<?php

namespace App\Console\Commands;

use App\Content;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class SendPodcastExpiryReminders extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:send-podcast-expiry-reminders';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $expireDate = Carbon::now()->addDays(10)->toDateString();
        $todayExpireDate = Carbon::now()->toDateString();

        $contents = Content::whereDate('expire_date', $expireDate)->get();
        $todayContents = Content::whereDate('expire_date', $todayExpireDate)->get();

        // Log::info('value',['expireDate'=>$expireDate, 'todayExpireDate'=>$todayExpireDate, 'contents'=>$contents, 'todayContents'=>$todayContents]);

        foreach ($contents as $content) {
            try {
                $content->createdByUser->notify(new \App\Notifications\PodcastExpiryReminder($content));
            } catch (\Exception $e) {
                Log::error("Failed to send podcast expiry reminder for content ID: {$content->id}", [
                    'user_id' => $content->createdByUser->id,
                    'error' => $e->getMessage(),
                ]);
            }
        }

        foreach ($todayContents as $content) {
            try {
                $content->createdByUser->notify(new \App\Notifications\PodcastExpiryReminder($content));
            } catch (\Exception $e) {
                Log::error("Failed to send today's podcast expiry reminder for content ID: {$content->id}", [
                    'user_id' => $content->createdByUser->id,
                    'error' => $e->getMessage(),
                ]);
            }
        }
    }

}
