<?php

namespace App\Console\Commands;
use App\User;
use App\Notifications\SendBetaUsersTestingEmail;
use App\Notifications\SendSpeakersEmail;
use Illuminate\Console\Command;
use App\SiteConfig;
use Carbon\Carbon;
use Illuminate\Support\Facades\Notification;

class SendSpeakerEmailCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'send:speakers-email';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send email to speakers for new year';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $accessToken = SiteConfig::where('name', 'mail_access_token')->first();
        if (isset($accessToken)) {
            config([
                'mail.from.address' => siteconfig('from_email'),
                'mail.from.name' => siteconfig('from_name'),
                'mail.password' => $accessToken->val,
            ]);
        }

        //Send email

        $userArray = [];
        if(env('APP_ENV_CODE') == "production"){
            $userArray = [
                    ["name" => "Scott Lynn, Exec. VP", "email" => "slynn@rymanhp.com"],
                    ["name" => "Adam Barber, MHPS, PLLC", "email" => "abarber@mhpslaw.com"],
                    ["name" => "John Wilks, MHPS, PLLC", "email" => "jwilks@mhpslaw.com"],
                    ["name" => "Jonathan Farmer, Spencer Fane", "email" => "jfarmer@spencerfane.com"],
                    ["name" => "Adam Dread", "email" => "adam@adamdread.com"],
                    ["name" => "Joey Fuson", "email" => "joe@freemanfuson.com"],
                    ["name" => "Amy Bryant", "email" => "AmyBryant@jisnashville.gov"],
                    ["name" => "Cathy Speers Johnson", "email" => "cathy@cpj.law"],
                    ["name" => "Catherine S. Eaton", "email" => "catherine@eatonfamilylawfirm.com"],
                    ["name" => "Christina Stubblefield", "email" => "christina.stubblefield@glidefast.com"],
                    ["name" => "J.K. Simms", "email" => "jk@thompsonburton.com"],
                    ["name" => "Kurt Myers", "email" => "kurt@myerspllc.com"],
                    ["name" => "Josh Offutt", "email" => "josh@joffuttlaw.com"],
                    ["name" => "Kelly Holmes", "email" => "kellysholmes411@gmail.com"],
                    ["name" => "Heather Warmbrod", "email" => "hello@heatherwarmbrod.com"],
                    ["name" => "Blakely Hunze-Austin", "email" => "blakelyhunze1993@gmail.com"],
            ];
        }else{
            $userArray = [
                [
                    'name' => 'Priyanshi Sachan',
                    'email' => 'priyanshi.sachan@kernelequity.com'
                ],
                [
                    'name' => 'Rahul Upadhyay',
                    'email' => 'rahul@kernelequity.com'
                ],
                [
                    'name' => 'Maulesh Pandya',
                    'email' => 'maulesh.pandya@kernelequity.com'
                ],
                [
                    'name' => 'Support',
                    'email' => 'support@clearly.legal'
                ]
            ];
        }
        // $userArray = [
        //     [
        //         'name' => 'Priyanshi Sachan',
        //         'email' => 'priyanshi.sachan@kernelequity.com'
        //     ],
        //     [
        //         'name' => 'Rahul Upadhyay',
        //         'email' => 'rahul@kernelequity.com'
        //     ],
        //     [
        //         'name' => 'Maulesh Pandya',
        //         'email' => 'maulesh.pandya@kernelequity.com'
        //     ],
        //     // [
        //     //     'name' => 'Support',
        //     //     'email' => 'support@clearly.legal'
        //     // ]
        // ];

        $currentDate = Carbon::now();
        $desiredDate = Carbon::parse('2025-01-23');

        if ($currentDate->isSameDay($desiredDate)) {
            foreach ($userArray as $userData) {
                // $user = User::make(['email' => $userData['email']]);

                Notification::route('mail', $userData['email'])
                ->notify(new SendSpeakersEmail($userData['name']));
            }
        }

    }

}

