<?php

namespace App\Console\Commands;

use App\AppUserAuthorization;
use App\Content;
use App\ContentFiles;
use App\ContentListener;
use App\User;
use App\UserCredits;
use Carbon\Carbon;
use Exception;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;
class SendSubmitRemainingCreditNotification extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:send-submit-remaining-credit-notification';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Alert users when they have listened to an episode and have not submitted it';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $pendingSubmissions = UserCredits::where('submission_id', 0)
        ->groupBy('user_id', 'content_file_id')
        ->get();

        $usersToNotify = [];

        foreach ($pendingSubmissions as $pending) {
            $isCompleted = ContentListener::where('user_id', $pending->user_id)
                ->where('content_file_id', $pending->content_file_id)
                // ->where('listen_status', 1)
                // ->whereBetween('created_at', [Carbon::now()->subDays(4)->startOfDay(), Carbon::now()])
                ->exists();

            if ($isCompleted) {
                $usersToNotify[$pending->user_id][] = $pending->content_file_id;
            }
        }

        foreach ($usersToNotify as $userId => $contentFileIds) {
            $user = User::find($userId);
            if ($user) {
                // Fetch content file names
                $contentFiles = ContentFiles::whereIn('id', $contentFileIds)->get();
                $podcastYetToSubmit = $contentFiles->pluck('file_name')->toArray();
                
                // Send notification with file names
                $this->sendPushNotification($user, $podcastYetToSubmit);
            } else {
                Log::warning("User not found: " . $userId);
            }
        }
    }
        
        private function sendPushNotification($user, $podcastYetToSubmit)
         {
            $deviceToken = AppUserAuthorization::where('user_id',$user->id)->latest()->first();

            // foreach($deviceToken as $token){
                if($deviceToken != null){
                if($deviceToken->device_token){
                    foreach($podcastYetToSubmit as $podcast){
                        $message = "You have not submitted your completed podcast, $podcast. Submit today to earn your CLE.";
                        $this->sendFCMNotification($deviceToken->device_token, $message);
                    }
                }else{
                    Log::warning('Device token invalid or not found');
                }   
            }
            // }         
         }

         private function sendFCMNotification($deviceToken, $message)
         {
            try {
                $messaging = app('firebase.messaging');
    
                $message = CloudMessage::withTarget('token', $deviceToken)
                     ->withNotification(Notification::create('CLE Reminder', $message))
                     ->withData(['action' => "pending_credit_submission"]);
    
                $messaging->send($message);
                Log::info("Notification sent successfully.", ['data' => $message ]);

            } catch (Exception $e) {
                Log::info("FCM:\n", ['Exception' => $e]);
            }
         }
         
}
