<?php

namespace App\Console\Commands;

use App\Content;
use App\ContentFiles;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;

class SetTempExpireDate extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'admin:set-temp-expire-date';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Set temp expire date for to existing content';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $contents = Content::all();
        foreach ($contents as $content) {
            if (!is_null($content->expire_date)) {
                $temp_expire_date = getTempExpireDate($content->expire_date);

                Log::info($temp_expire_date);
                $content->update(['temp_expire_date' => $temp_expire_date]);     
            } else {
                continue;
            }
        }
    }
}

