<?php

namespace App\Console\Commands;

use App\Content;
use App\ContentFiles;
use App\UserCredits;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;

class StoreContentFileSize extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'admin:add-content-file-size';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Add content file size to existing episodes';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $contentFiles = ContentFiles::where('size',0)->get();
        foreach ($contentFiles as $file) {
            $filePath = "upload_file/" . $file['file'];
        
            if (Storage::exists($filePath)) {
                $sizeInBytes = Storage::size($filePath);
                $sizeInMB = bytesToMB($sizeInBytes);

                $file->update(['size' => $sizeInMB]);     
            }
        }
    }
}

