<?php

namespace App\Console\Commands;

use App\Faculty;
use Illuminate\Console\Command;
use Illuminate\Support\Str;

class StoreFacultySlug extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'admin:add-faculty-slug';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Add faculty slug to existing faculty members';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $faculty = Faculty::all();
        foreach ($faculty as $f) {
            $f->slug = Str::slug($f->name);
            $f->save();
        }
    }
}

