<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

//Alias the League Google OAuth2 provider class
use League\OAuth2\Client\Provider\Google;
use Stevenmaguire\OAuth2\Client\Provider\Microsoft;
use League\OAuth2\Client\Grant\RefreshToken;
use App\SiteConfig;
use Illuminate\Support\Facades\Log;

class TokenGenerationCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'token:refersh';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'access token refersh';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        ini_set('max_execution_time', '0');
        // Log::info('In function oauth2');
        // Log::info("This is check refresh token of schedular");
        $clientId = siteconfig('mail_client_id');
        $clientSecret = siteconfig('mail_client_secret');
        $tenantId = siteconfig('mail_tenant_id');
        $providerName = siteconfig('mail_providername');
        $redirectUri = route('mailoauth2');

        if ($providerName == 'Google') {
                $params = [
                    'clientId' => $clientId,
                    'clientSecret' => $clientSecret,
                    'redirectUri' => $redirectUri,
                    'accessType'=> 'offline',
                ];
                $provider = new Google($params);

        } else if($providerName == 'Microsoft') {
                $params = [
                    'clientId' => $clientId,
                    'clientSecret' => $clientSecret,
                    'redirectUri' => $redirectUri,
                    'urlAuthorize'              => 'https://login.microsoftonline.com/' . $tenantId . '/oauth2/v2.0/authorize',
                    'urlAccessToken'            => 'https://login.microsoftonline.com/' . $tenantId . '/oauth2/v2.0/token',
                ];
                $provider = new Microsoft($params);
        }
        $accessToken = SiteConfig::where('name','mail_refresh_token')->first();
		$refesh = $accessToken->val;
        if($refesh !== '' && $refesh !== null){
            // Log::info('In function oauth2 if 1');
            $roptions = [
                'clientSecret' => $clientSecret,
                'client_id' => $clientId,
                'redirectUri' => $redirectUri,
                'grant_type' => 'refresh_token',
                'refresh_token' => $refesh,
				'accessType'=> 'offline',
				'prompt'=>'none'
            ];
            $refershtoken = $provider->getAccessToken(
                    'refresh_token',
                    $roptions
                );

            echo '1.Refresh Token : ', $rtoken = $refershtoken->getRefreshToken();
			if($rtoken !== '' && $rtoken !== null){
                SiteConfig::updateOrCreate(
                    ['name' => 'mail_refresh_token'],
                    ['val' => $rtoken, 'status' => 1, 'type' => 'text']
                );
            }

            echo '<br />1.AccessToken: ' , $refershtoken->getToken();
            SiteConfig::updateOrCreate(
                ['name' => 'mail_access_token'],
                ['val' => $refershtoken->getToken(), 'status' => 1, 'type' => 'text']
            );
        }
    }
}
