<?php

namespace App\Console\Commands;

use App\ContentFiles;
use App\ContentListener;
use App\Notifications\SendWeeklySubscriptionSummaryReport;
use App\User;
use App\Submissions;
use App\Notifications\SendWeeklySummaryReport;
use App\SiteConfig;
use App\Subscription;
use App\UserCredits;
use Illuminate\Console\Command;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

class WeeklySubscriptionSummaryEmail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'send:weekly-subscription-summary-email';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send weekly subscription summary report via email';

    /**
     * Execute the console command.
     */
    public function handle()
    {

        $accessToken = SiteConfig::where('name', 'mail_access_token')->first();
        if (isset($accessToken)) {
            config([
                'mail.from.address' => siteconfig('from_email'),
                'mail.from.name' => siteconfig('from_name'),
                'mail.password' => $accessToken->val,
            ]);
        }

        $lastMonday = Carbon::now()->startOfWeek(Carbon::MONDAY)->subWeek();
        $lastSunday = Carbon::now()->startOfWeek(Carbon::MONDAY)->subDay();
        
        // Get all users with active subscriptions
        $subscriptions = Subscription::with('user')->where('stripe_subscription_status', 'active')->where('status', 1)->whereBetween('created_at', [$lastMonday, $lastSunday])->get();
    
        if(siteconfig('weekly_activation_emails') == 1)
        {
            //send activation email to admin 
            $emails = siteconfig('activation_email_admin');
            if (!empty($emails)) {
                $emailsArray = explode(',', $emails);
                foreach ($emailsArray as $email) {
                    $admin = User::make(['email' => $email]);
                    if ($admin) {
                        $admin->notify(new SendWeeklySubscriptionSummaryReport($subscriptions));
                    }else {
                        $this->warn("User with email $email not found.");
                    }
                }
            }
        }
    }
}
