<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\Log;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
        'App\Console\Commands\ActivityLogArchiveCommand',
        'App\Console\Commands\TokenGenerationCommand',
        'App\Console\Commands\SendCourseCompletionEmailsToAdmin',
        'App\Console\Commands\PoadcastAccessLimitCron',
        'App\Console\Commands\SendPodcastExpiryReminders',
        'App\Console\Commands\SendDailyExcel',
        'App\Console\Commands\WeeklySummaryEmail',
        'App\Console\Commands\WeeklySubscriptionSummaryEmail',
        'App\Console\Commands\MonthlySubscriptionSummaryEmail',
        'App\Console\Commands\DeleteUserCredits',
        'App\Console\Commands\SendSpeakerEmailCron',
        'App\Console\Commands\SendContinuePodcastNotification',
        'App\Console\Commands\SendSubmitRemainingCreditNotification',
        'App\Console\Commands\GenerateRssDaily'

    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $schedule->command('archive:activitylogs')->daily()->onOneServer();
        $schedule->command('token:refersh')->everyThirtyMinutes();
        $schedule->command('send:courseompletionemails')->dailyAt('23:59');
        $schedule->command('poadcastaccesslimit:cron')->everyFifteenMinutes();
        $schedule->command('app:send-podcast-expiry-reminders')->dailyAt('00:05');
        $schedule->command('send:daily-excel')->dailyAt('23:59')->withoutOverlapping();
        $schedule->command('send:weekly-summary-email')->mondays()->at('00:05')->withoutOverlapping(); 
        $schedule->command('send:weekly-subscription-summary-email')->mondays()->at('00:05')->withoutOverlapping();  
        $schedule->command('send:monthly-subscription-summary-email')->monthlyOn(1, '00:05')->withoutOverlapping(); 
        $schedule->command('app:delete-expired-user-credits')->dailyAt('00:05');
        //$schedule->command('send:beta-testing-email')->timezone('America/Chicago')->dailyAt('09:00');
        $schedule->command('send:beta-testing-email')->timezone('Asia/Kolkata')->dailyAt('18:00');
        $schedule->command('send:speakers-email')->timezone('Asia/Kolkata')->dailyAt('16:00');

        $schedule->command('app:send-submit-remaining-credit-notification')->dailyAt('09:00')->withoutOverlapping(); 
        $schedule->command('app:send-continue-podcast-notification')->dailyAt('09:30')->withoutOverlapping(); 
        $schedule->command('generate:rss-for-content')->dailyAt('23:59')->withoutOverlapping();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
