<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Model;

class ContentListener extends Model
{
    use HasFactory;
    /**
     * Overwrite created_by field value with currently logged in user.
     * Set @var has_created_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */
    protected $has_created_by = true;

    /**
     * Overwrite updated_by field value with currently logged in user.
     * Set @var has_updated_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */

    protected $has_updated_by = true;

    /**
     * Define feilds name which have html tags
     * Set @var notStripTags add DB Table column name which column have html tags.
     *
     * @var array
     */

    public static $notStripTags = [];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'content_id',
        'content_file_id',
        'user_id',
        'listen_time',
        'listen_status',
        'completed_at',
        'created_by',
        'updated_by'
    ];

    protected $appends = ['listen_time_in_seconds'];

    public function contents()
    {
        return $this->hasOne(Content::class, 'id', 'content_id');
    }

    public function contentFiles()
    {
        return $this->hasOne(ContentFiles::class, 'id', 'content_file_id');
    }

    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }

    public function getListenTimeInSecondsAttribute()
    {
        // return minuteSecondToSeconds($this->listen_time);
        return $this->listen_time;
    }
}
