<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class ContentsStates extends Model
{
    use HasFactory;
    /**
     * Overwrite created_by field value with currently logged in user.
     * Set @var has_created_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */
    protected $has_created_by = true;

    /**
     * Overwrite updated_by field value with currently logged in user.
     * Set @var has_updated_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */

    protected $has_updated_by = true;

    /**
     * Define feilds name which have html tags
     * Set @var notStripTags add DB Table column name which column have html tags.
     *
     * @var array
     */

    public static $notStripTags = [];

    protected $appends = ['state_name'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'contents_id',
        'bar_id',
        'credit_provided_by_the_course',
        'state_bar_id',
        'status',
        'created_by',
        'updated_by'
    ];

    public function content()
    {
        return $this->belongsTo(Content::class, 'id', 'contents_id');
    }

    public function getStateNameAttribute()
    {
        $bar = $this->belongsTo(Bar::class, 'bar_id', 'id')->first();
        return $bar ? $bar->state_name : null;
    }
}
