<?php

namespace App\Exceptions;

use Exception;
use Illuminate\Auth\AuthenticationException;
use Session;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Support\Facades\Log;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Throwable;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var array
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array
     */
    protected $dontFlash = [
        'password',
        'password_confirmation',
    ];

    /**
     * Render an exception into an HTTP response.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Exception  $exception
     * @return \Illuminate\Http\Response
     */
    public function render($request, Throwable $exception)
    {
        if ($exception instanceof AuthenticationException) {
            return $this->handleAuthenticationException($request, $exception);
        }
        if ($exception instanceof \Illuminate\Session\TokenMismatchException) {
                return redirect()->route('login');
        }
        if ($exception instanceof  \BadMethodCallException) {
            abort(404);
        }
        return parent::render($request, $exception);
    }

    protected function handleAuthenticationException($request, AuthenticationException $exception)
    {
        if ($request->expectsJson()) {
            $message = 'Your session has expired. Please log in again to continue.';

            // Check if the exception is due to token expiration
            // if ($exception->getCode() === 9) {
            //     $message = 'Your session has expired. Please log in again to continue.';
            // }

            return response()->json(['message' => $message], 401);
        }

        return parent::unauthenticated($request, $exception);
    }

    public function report(Throwable $e)
    {
        if ($e instanceof \League\OAuth2\Server\Exception\OAuthServerException && $e->getCode() === 9) {
            Log::warning('Your session has expired. Token Expired. Please log in again to continue.');
            return;
        }
        parent::report($e);
    }
}
