<?php 

namespace App\Exports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class SubmissionExport implements FromCollection, WithHeadings
{
    protected $submissions;

    public function __construct(Collection $submissions)
    {
        $this->submissions = $submissions;
    }

    public function collection()
    {
        // Return a collection with only the desired columns
        return $this->submissions->map(function ($submission) {
            return [
                $submission->podcast_bar_id,
                $submission->user_bar_id,
                // $submission->podcast_title,
                // $submission->user_name,
                // $submission->state_name,
                $submission->dual,
                $submission->ethics,
                $submission->general,"",
                // $submission->credits_submitted,
                $submission->created_at,
            ];
        });
    }

    public function headings(): array
    {
        // Define the table headers for the exported data
        return [
            'CourseID',
            'AttorneyID',
            // 'Course Title',
            // 'Attorney Name',
            // 'BAR Name',
            'DualHours',
            'EPHours',
            'GenHours',
            'CourseInstructor',
            // 'Credits Submitted',
            'AttendDate',
        ];
    }
}
