<?php 

namespace App\Exports;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class SubscriptionExport implements FromCollection, WithHeadings
{
    protected $subscriptions;

    public function __construct(Collection $subscriptions)
    {
        $this->subscriptions = $subscriptions;
    }

    public function collection()
    {
        return $this->subscriptions->map(function ($subscription) {
            $data = [
                $subscription->user_firstname."".$subscription->user_lastname,
                $subscription->bar_name,
                $subscription->stripe_subscription_status,
                $subscription->start_date,
                $subscription->end_date,
            ];
        
            // Conditionally include firm name only for user_type_id 1
            if (Auth::user()->user_type_id == 1) {
                $data[] = $subscription->firm_name;
            }
        
            return $data;
        });
    }

    public function headings(): array
    {
        $headers = [
            'User Name',
            'BAR Name',
            'Subscription Status',
            'Start Date',
            'End Date',
        ];
        
        // Conditionally add Firm Name header only for user_type_id 1
        if (Auth::user()->user_type_id == 1) {
            $headers[] = 'Firm Name';
        }
        
        return $headers;
    }
}
