<?php

namespace App;

use App\Traits\DisplayOrder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FAQs extends Model
{
    use HasFactory, DisplayOrder, SoftDeletes;

    protected $table = "faqs";
    protected $fillable = [
        'question',
        'answer',
        'status',
        'display_order',
    ];

    public static $notStripTags = ['answer'];

    public function getResult($request)
    {

        // Set default parameter values
        $order_by = !empty($request->get('order_by')) ? $request->get('order_by') : 'id';
        $order = !empty($request->get('order')) ? $request->get('order') : 'asc';
        $defaultper_page = !empty($request->get('per_page')) ? $request->get('per_page') : siteconfig('records_per_page', 0);

        // Fetch pages list
        $pages = new FAQs();

        // Search
        if (!empty($request->get('search'))) {
            $searchStr = $request->get('search');
            $escape = "ESCAPE '|'";
             if(substr_count($searchStr,"|")){
                $searchStr = str_replace('\\', '\\\\\\', $searchStr);
                 $escape = "";
             }
            // added escape for searching backslash issue DLC-140
            $pages = $pages->where(function ($query) use ($searchStr,$escape) {
                $query
                ->whereRaw('question LIKE ?  '.$escape, '%'.$searchStr.'%')
                ->orWhereRaw('answer LIKE ?  '.$escape, '%'.$searchStr.'%');
            });
        }

        // Status
        if ($request->get('status') !== null) {
            $pages = $pages->where('status', $request->get('status'));
        }
        //if per_page not set then all record value use for per_page
        // Curretly it is not in Admin user listing as we are using data table paging
        // but have kept this for API integration
        $per_page = !empty($defaultper_page) ? $defaultper_page : $pages->count();

        // Order By & Pagination
        $pages = $pages->orderBy($order_by, $order)->paginate($per_page);

        return $pages;
    }

    public function getImagePathAttribute()
    {
        return getImageUrl($this->image, 'releases');
    }

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

}
