<?php

namespace App;

use App\Model;

class FacultyInquiry extends Model
{

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'first_name',
        'last_name',
        'phone_number',
        'email',
        'bio_link',
        'firm_name',
        'ip_address',
    ];

    /**
     * The get result based on search criteria.
     * @param  \Illuminate\Http\Request  $request
     * @return object App\ContactUs
     */
    public function getResult($request)
    {
        // Set default parameter values
        $order_by = !empty($request->get('order_by')) ? $request->get('order_by') : 'id';
        $order = !empty($request->get('order')) ? $request->get('order') : 'desc';
        $defaultper_contacts = !empty($request->get('per_page')) ? $request->get('per_page') : siteconfig('records_per_page', 0);

        // Fetch ContactUs list
        $contacts = new FacultyInquiry;

        // Search
        if (!empty($request->get('search'))) {
            $searchStr = $request->get('search');
            $escape = "ESCAPE '|'";
             if(substr_count($searchStr,"|")){
                $searchStr = str_replace('\\', '\\\\\\', $searchStr);
                 $escape = "";
             }
            // added escape for searching backslash issue DLC-140
            $contacts = $contacts->where(function ($query) use ($searchStr,$escape) {
                $query
                ->whereRaw('first_name LIKE ?  '.$escape, '%'.$searchStr.'%')
                ->orWhereRaw('last_name LIKE ? '.$escape, '%'.$searchStr.'%')
                ->orWhereRaw('phone_number LIKE ? '.$escape, '%'.$searchStr.'%')
                ->orWhereRaw('email LIKE ? '.$escape, '%'.$searchStr.'%');
            });
        }


        //if per_contacts not set then all record value use for per_contacts
        // Curretly it is not in Admin user listing as we are using data table paging
        // but have kept this for API integration
        $per_contacts = !empty($defaultper_contacts) ? $defaultper_contacts : $contacts->count();

        // Order By & Pagination
        $contacts = $contacts->orderBy($order_by, $order)->paginate($per_contacts);

        return $contacts;
    }

    public function categories()
    {
        return $this->belongsToMany(Category::class);
    }
}