<?php

namespace App;

use App\Model;
use Auth;

class Firm extends Model
{
    /**
     * Overwrite created_by field value with currently logged in user.
     * Set @var has_created_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */
    protected $has_created_by = true;

    /**
     * Overwrite updated_by field value with currently logged in user.
     * Set @var has_updated_by to false if created_by field does not exist in DB Table.
     *
     * @var boolean
     */

    protected $has_updated_by = true;

    /**
     * Define feilds name which have html tags
     * Set @var notStripTags add DB Table column name which column have html tags.
     *
     * @var array
     */

    public static $notStripTags = [];


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'code',
        'user_id',
        'address1',
        'address2',
        'city',
        'state_id',
        'zipcode',
        'country',
        'billing_name',
        'billing_email',
        'sameasfirm',
        'billing_address1',
        'billing_address2',
        'billing_city',
        'billing_state_id',
        'billing_zipcode',
        'billing_country',
        'user_subscription',
        'firm_size',
        'status',
        'created_by',
        'updated_by'
    ];

    public function firmadmin(){
        return $this->hasOne('App\User','id','user_id')->where('user_type_id',2);
    }

    public function firmUsers(){
        return $this->hasMany('App\User','firmcode','code')->where('user_type_id',3)->select('id','firmcode','first_name','last_name');
    }

    /**
     * fetch admin name value
     */
    public function getAdminnameAttribute()
    {
        if (isset($this->attributes['user_id']) && !empty($this->attributes['user_id'])) {
            return trim($this->firmadmin->first_name);
        }
    }

    public function getAdminemailAttribute()
    {
        if (isset($this->attributes['user_id']) && !empty($this->attributes['user_id'])) {
            return trim($this->firmadmin->email);
        }
    }

    public function getAdminphoneAttribute()
    {
        if (isset($this->attributes['user_id']) && !empty($this->attributes['user_id'])) {
            return trim($this->firmadmin->phone);
        }
    }

    /**
     * The get result based on search criteria.
     * @param  \Illuminate\Http\Request  $request
     * @return object App\Firm
     */
    public function getResult($request)
    {

        // Set default parameter values
        $order_by = !empty($request->get('order_by')) ? $request->get('order_by') : 'id';
        $order = !empty($request->get('order')) ? $request->get('order') : 'asc';
        $defaultper_firm = !empty($request->get('per_page')) ? $request->get('per_page') : siteconfig('records_per_page', 0);

        // Fetch firms list
        $firms = new Firm;

        //in firm there is also app user firm data added so we can get data where code is not null
        $firms = $firms->whereNotNull('code')->where('code', '<>', '');

        // Search
        if (!empty($request->get('search'))) {
            $searchStr = $request->get('search');
            $escape = "ESCAPE '|'";
             if(substr_count($searchStr,"|")){
                $searchStr = str_replace('\\', '\\\\\\', $searchStr);
                 $escape = "";
             }
            // added escape for searching backslash issue DLC-140
            $firms = $firms->where(function ($query) use ($searchStr,$escape) {
                $query
                ->whereRaw('name LIKE ?  '.$escape, '%'.$searchStr.'%');
            });
        }

        if(Auth::user()->user_type == 2){
            $firms = $firms->where('user_id', Auth::user()->id);
        }

        // Status
        if ($request->get('status') !== null) {
            $firms = $firms->where('status', $request->get('status'));
        }


        //if per_firm not set then all record value use for per_firm
        // Curretly it is not in Admin user listing as we are using data table paging
        // but have kept this for API integration
        $per_firm = !empty($defaultper_firm) ? $defaultper_firm : $firms->count();

        // Order By & Pagination
        $firms = $firms->orderBy($order_by, $order)->paginate($per_firm);

        return $firms;
    }

}
