<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Bar;
use App\User;
use App\State;
use Illuminate\Validation\Rule;
use App\Notifications\UserVerification;
use App\Events\BulkAction;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class BarController extends Controller
{
    protected $indexRoute = 'bar.index';
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $bar = new Bar;
        $bar = $bar->getResult($request);
        // Render view
        return view('admin.modules.bar.index')->with('bars', $bar);
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $bar = new Bar;
        $data = $this->getBarPageData($bar);
        return view('admin.modules.bar.addedit')->with($data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, Bar $bar)
    {
        $request = $this->stripHtmlTags($request, Bar::$notStripTags);
        $this->validation($request);
        $data = $request->all();

        if($data['annual_price_stripe_price_id'] == 'other'){
            $data['annual_price_stripe_price_id'] = createStripePriceId($data['other_annual_price_name'],$data['other_annual_price_amount'],config('priceformetadata')['annual_price']);
        }
        if($data['surcharge_fees_stripe_price_id'] == 'other'){
            $data['surcharge_fees_stripe_price_id'] = createStripePriceId($data['other_surcharge_fees_name'],$data['other_surcharge_fees_amount'],config('priceformetadata')['surcharge_fees']);
        }
        if($data['submission_fees_stripe_price_id'] == 'other'){
            $data['submission_fees_stripe_price_id'] = createStripePriceId($data['other_submission_fees_name'],$data['other_submission_fees_amount'],config('priceformetadata')['submission_fees']);
        }
        $voluntary_bar = 0;
        if(isset($data['voluntary_bar'])){
            $voluntary_bar = $data['voluntary_bar'];
        }
        $data['voluntary_bar'] = $voluntary_bar;
        $cle_mandatory = 0;
        if(isset($data['cle_mandatory'])){
            $cle_mandatory = $data['cle_mandatory'];
        }
        $data['cle_mandatory'] = $cle_mandatory;
        $podcast_accepted = 0;
        if(isset($data['podcast_accepted'])){
            $podcast_accepted = $data['podcast_accepted'];
        }
        $data['podcast_accepted'] = $podcast_accepted;
        $auto_credit_upload = 0;
        if(isset($data['auto_credit_upload'])){
            $auto_credit_upload = $data['auto_credit_upload'];
        }
        $data['auto_credit_upload'] = $auto_credit_upload;

        $bar->fill($data);
        $bar->save();

        if ($request->get('btnsave') == 'savecontinue') {
            return redirect()->route('bar.edit', ['bar' => $bar->id])->with("success", __('bar.create_success', ['name' => $request->get('name')]));
        } elseif ($request->get('btnsave') == 'save') {
            return redirect()->route($this->indexRoute)->with("success", __('bar.create_success', ['name' => $request->get('name')]));
        } else {
            return redirect()->route($this->indexRoute);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Bar  $bar
     * @return \Illuminate\Http\Response
     */
    public function show(Bar $bar)
    {
        $data = $this->getBarPageData($bar);
        return view('admin.modules.bar.view')->with($data);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Bar  $bar
     * @return \Illuminate\Http\Response
     */
    public function edit(Bar $bar)
    {
        $data = $this->getBarPageData($bar);
        
        return view('admin.modules.bar.addedit')->with($data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Bar  $bar
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Bar $bar)
    {
        $request = $this->stripHtmlTags($request, Bar::$notStripTags);
        $this->validation($request,$bar->id);

        $data = $request->all();

        $voluntary_bar = 0;
        if(isset($data['voluntary_bar'])){
            $voluntary_bar = $data['voluntary_bar'];
        }
        $data['voluntary_bar'] = $voluntary_bar;
        $cle_mandatory = 0;
        if(isset($data['cle_mandatory'])){
            $cle_mandatory = $data['cle_mandatory'];
        }
        $data['cle_mandatory'] = $cle_mandatory;
        $podcast_accepted = 0;
        if(isset($data['podcast_accepted'])){
            $podcast_accepted = $data['podcast_accepted'];
        }
        $data['podcast_accepted'] = $podcast_accepted;
        $auto_credit_upload = 0;
        if(isset($data['auto_credit_upload'])){
            $auto_credit_upload = $data['auto_credit_upload'];
        }
        $data['auto_credit_upload'] = $auto_credit_upload;
        $validate = 'no';
        if($bar->users->count() > 0 && $bar->status == 1 && $data['status'] == 0){
            $data['status'] = 1;
            $validate = 'yes';
        }

        $bar->fill($data);
        $bar->save();
        if($validate == 'yes'){
            $message = __('bar.update_success_validate', ['name' => $request->get('state_name')]);
        }
        else{
            $message = __('bar.update_success', ['name' => $request->get('state_name')]);
        }


        if ($request->get('btnsave') == 'savecontinue') {
            return redirect()->route('bar.edit', ['bar' => $bar->id])->with("success", $message);
        } elseif ($request->get('btnsave') == 'save') {
            return redirect()->route($this->indexRoute)->with("success", $message);
        } else {
            return redirect()->route($this->indexRoute);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Bar  $bar
     * @return \Illuminate\Http\Response
     */
    public function destroy(Bar $bar)
    {
        //
    }
     /**
     * Validate the Form
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    private function validation($request, $id = 0)
    {
        $rules = [
            'state_name' => 'required',
            'hours_needed_per_cycle' => [
                'required',
                'integer',
                function ($attribute, $value, $fail) use ($request) {
                    if($request->hours_needed_per_cycle != ($request->general + $request->ethics)){
                        $fail(__('bar.hours_total_not_match'));
                    }
                },
            ],
            'annual_price_stripe_price_id'=> ['sometimes','required'],
            'other_annual_price_name' => [
                Rule::requiredIf(function () use ($request) {
                    return $request->annual_price_stripe_price_id == 'other';
                }),
            ],
            'other_annual_price_amount' => [
                Rule::requiredIf(function () use ($request) {
                    return $request->annual_price_stripe_price_id == 'other';
                }),
            ],
            'surcharge_fees_stripe_price_id'=>['sometimes','required'],
            'other_surcharge_fees_name' => [
                Rule::requiredIf(function () use ($request) {
                    return $request->surcharge_fees_stripe_price_id == 'other';
                }),
            ],
            'other_surcharge_fees_amount' => [
                Rule::requiredIf(function () use ($request) {
                    return $request->surcharge_fees_stripe_price_id == 'other';
                }),
            ],
            'submission_fees_stripe_price_id'=> ['sometimes','required'],
            'other_submission_fees_name' => [
                Rule::requiredIf(function () use ($request) {
                    return $request->submission_fees_stripe_price_id == 'other';
                }),
            ],
            'other_submission_fees_amount' => [
                Rule::requiredIf(function () use ($request) {
                    return $request->submission_fees_stripe_price_id == 'other';
                }),
            ],
            'cycle_length' => 'required|integer',
            'general' => 'required|integer',
            'ethics' => 'required|integer',
            'shortest_length_accepted' => 'nullable|integer',
        ];
        if($id > 0){
            $rules['state_id'] = "required|unique:bars,state_id,{$id},id,deleted_at,NULL";
        }else{
            $rules['state_id'] = ['required', Rule::unique('bars')->whereNull('deleted_at')];
        }
        $messages = [
            'state_id.required' => 'The state field is required.',
            'state_id.unique' => 'The state has already been taken.',
            'other_annual_price_name.required' => 'The '.__('bar.other_annual_price_name').' field is required.',
            'other_annual_price_amount.required' => 'The '.__('bar.other_annual_price_amount').' field is required.',
            'other_surcharge_fees_name.required' => 'The '.__('bar.other_surcharge_fees_name').' field is required.',
            'other_surcharge_fees_amount.required' => 'The '.__('bar.other_surcharge_fees_amount').' field is required.',
            'other_submission_fees_name.required' => 'The '.__('bar.other_submission_fees_name').' field is required.',
            'other_submission_fees_amount.required' => 'The '.__('bar.other_submission_fees_amount').' field is required.',
        ];

        $this->validate($request, $rules, $messages);
    }
    /**
     * Apply change visible
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function changestatus(Request $request)
    {
        $bar = Bar::findOrFail($request->id);

        if ($bar->status  == 0) {
            Bar::where('id', $request->id)->update(['status' => 1]);
            $message = __('bar.record_active_success');
        }else{
            $validate = 'no';
            if($bar->users->count() > 0 || $bar->contentsStates->count() > 0){
                $validate = 'yes';
            }
            else{
                Bar::where('id', $request->id)->update(['status' => 0]);
            }
            if ($validate == 'yes') {
                $message = __('bar.record_inactive_success_validate');
            } else {
                $message = __('bar.record_inactive_success');
            }

        }
        return redirect()->back()->with('success', $message);
    }

    /**
     * Apply bulk action on selected items
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function bulkAction(Request $request)
    {

        $bar = new Bar();
        if ($request->get('bulk-action') == 'active') {
            foreach ($request->get('id') as $barID) {
                $barData = Bar::find($barID);
                if($barData->users->count() > 0 || $barData->contentsStates->count() > 0){
                    $validate = 'yes';
                }
                else{
                    $barData->update(['status' => 1]);
                }
            }
            $message = __('bar.active_success');
        } elseif ($request->get('bulk-action') == 'inactive') {
            $validate = 'no';
            foreach ($request->get('id') as $barID) {
                $barData = Bar::find($barID);
                if($barData->users->count() > 0 || $barData->contentsStates->count() > 0){
                    $validate = 'yes';
                }
                else{
                    $barData->update(['status' => 0]);
                }
            }
            if ($validate == 'yes') {
                $message = __('bar.inactive_success_validate');
            } else {
                $message = __('bar.inactive_success');
            }

        } elseif ($request->get('bulk-action') == 'delete') {
            foreach ($request->get('id') as $barID) {
                Bar::destroy($barID);
            }
            $message = __('bar.delete_success');
        }
        $bar::flushCache($bar);
        event(new BulkAction($bar->getTable(), $request->get('id'), $request->get('bulk-action')));
        return redirect()->back()->with('success', $message);
    }

    public function getBarPageData($bar){

        if(isset($bar->user_id) && !empty($bar->user_id)){
            $baradmin = User::find($bar->user_id);
            $bar->adminname = $baradmin->first_name;
            $bar->email = $baradmin->email;
            $bar->adminphone = $baradmin->phone;
        }
        $data['bar'] = $bar;
        $data['states'] = State::all()->pluck('name','id');
        return $data;
    }
}
