<?php

namespace App\Http\Controllers\Admin;

use App\ContactUs;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Events\BulkAction;
use App\Notifications\ContactUsDataNotification;
use App\User;
use Illuminate\Support\Facades\Notification;
use App\SiteConfig;
use Illuminate\Validation\ValidationException;

class ContactUsController extends Controller
{
    protected $indexRoute = 'course-category.index';
    /**
     * aaa
     * Display a listing of the resources.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $contacts = new ContactUs;
        $contactsData = $contacts->getResult($request);
        $resetLink = route('contact-us.index', ['search' => '']);
        // Render view
        return view('admin.modules.contactus.index')->with('contacts', $contactsData)->with('reset_link',$resetLink);
    }

    /**
     * Apply bulk action on selected items
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function bulkAction(Request $request)
    {
        $contactUs = new ContactUs();

        if ($request->get('bulk-action') == 'delete') {

            ContactUs::destroy($request->get('id'));

            $message = __('contact-us.delete_success');
        }
        $contactUs::flushCache($contactUs);
        event(new BulkAction($contactUs->getTable(), $request->get('id'), $request->get('bulk-action')));
        return redirect()->back()->with('success', $message);
    }
}
