<?php

namespace App\Http\Controllers\Admin;

use App\Events\BulkAction;
use App\FAQs;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class FAQsController extends Controller
{
    protected $indexRoute = 'faqs.index';
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $faqs = new FAQs();
        $faqs = $faqs->getResult($request);

        // Render view
        return view('admin.modules.faqs.index')->with('faqs', $faqs);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $faqs = new FAQs();
        return view('admin.modules.faqs.addedit')->with('faqs', $faqs);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, FAQs $faq)
    {
        $request = $this->stripHtmlTags($request, FAQs::$notStripTags);
        $rules = [
            'question' => 'required',
            'answer' => 'required',
        ];

        $this->validate($request, $rules);
        // Prepare Data Array
        $data = $request->all();
    
        // Save the Data
        $faq->fill($data);
        $faq->save();

        if ($request->get('btnsave') == 'savecontinue') {
            return redirect()->route('faqs.edit', ['faq' => $faq->id])->with("success", __('faqs.create_success', ['name'=>$request->get('name')]));
        } elseif ($request->get('btnsave') == 'save') {
            return redirect()->route($this->indexRoute)->with("success", __('faqs.create_success', ['name'=>$request->get('name')]));
        } else {
            return redirect()->route($this->indexRoute);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(FAQs $fAQs)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(FAQs $faq)
    {
        // $faqs=FAQs::where('id', $id)->findOrFail();
        return view('admin.modules.faqs.addedit')->with('faqs', $faq);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, FAQs $faq)
    {
        $request = $this->stripHtmlTags($request, FAQs::$notStripTags);
        $id = $faq->id;
        $rules = [
            'question' => 'required',
            'answer' => 'required',
            'display_order'=>'nullable|integer|min:1'
        ];

        $this->validate($request, $rules);

        // Prepare Data Array
        $data = $request->all();

        // Save the Data
        $faq->fill($data);
        $faq->save();

        if ($request->get('btnsave') == 'savecontinue') {
            return redirect()->back()->with("success", __('faqs.update_success', ['name'=>'FAQ']));
        } elseif ($request->get('btnsave') == 'save') {
            return redirect()->route($this->indexRoute)->with("success", __('faqs.update_success', ['name'=>'FAQ']));
        } else {
            return redirect()->route($this->indexRoute);
        }
    }

    public function bulkaction(Request $request)
    {
        $faqs = new FAQs();

        if ($request->get('bulk-action') == 'active') {
            FAQs::whereIn('id', $request->get('id'))->update(['status' => 1]);
            $message = __('faqs.active_success');
        } elseif ($request->get('bulk-action') == 'inactive') {
            $message = __('faqs.inactive_success');
            FAQs::whereIn('id', $request->get('id'))->update(['status' => 0]);
        } elseif ($request->get('bulk-action') == 'delete') {
            $needVerify = false;
            foreach ($request->get('id') as $faqsId) {
                $faqs = FAQs::findOrFail($faqsId);
                FAQs::destroy($faqsId);
            }
            if (!$needVerify) {
                $message = __('faqs.delete_success');
            } else {
                $message = __('faqs.delete_success_validate');
            }
        }
        // $faqs::flushCache($faqs);
        event(new BulkAction($faqs->getTable(), $request->get('id'), $request->get('bulk-action')));
        return redirect()->back()->with('success', $message);
    }
    /**
     * Apply change status
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function changestatus(Request $request)
    {
        $faqs = FAQs::findOrFail($request->id);
        $faqs->status = $faqs->status == 1?0:1;
        $faqs->save();
        $message = displayMessages('faqs', $faqs->status);
        return redirect()->back()->with('success', $message);
    }
}
