<?php

namespace App\Http\Controllers\Admin;

use App\Events\BulkAction;
use App\Faculty;
use App\Http\Controllers\Controller;
use App\PodcastRefSpeakers;
use Illuminate\Http\Request;

class FacultyController extends Controller
{
    protected $indexRoute = 'faculty.index';
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $faculty = new Faculty;
        $faculty = $faculty->getResult($request);

        // Render view
        return view('admin.modules.faculty.index')->with('faculty', $faculty);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $faculty = new Faculty();
        return view('admin.modules.faculty.addedit')->with('faculty', $faculty);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, Faculty $faculty)
    {
        $request = $this->stripHtmlTags($request, Faculty::$notStripTags);
        $rules = [
            'name' => 'required|max:100',
            'email' => 'required|email|regex:/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/',
            'status' => 'required',
            'profile_url' => 'nullable|url',
            // 'image' => 'required',
        ];

        $messages = [
            // 'image.required' => 'The image field is required.',
            'name.required' => 'The name field is required.'
        ];

        $this->validate($request, $rules, $messages);

        // Prepare Data Array
        $data = $request->all();

        // Save the Data
        $faculty->fill($data);
        $faculty->save();

        if ($request->get('btnsave') == 'savecontinue') {
            return redirect()->route('faculty.edit', ['faculty' => $faculty->id])->with("success", __('faculty.create_success', ['name'=>$request->get('name')]));
        } elseif ($request->get('btnsave') == 'save') {
            return redirect()->route($this->indexRoute)->with("success", __('faculty.create_success', ['name'=>$request->get('name')]));
        } else {
            return redirect()->route($this->indexRoute);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $faculty = Faculty::where('id', $id)->where('status', 1)->firstOrFail();
        return view('admin.modules.faculty.index')->with('faculty', $faculty);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Faculty $faculty)
    {
        return view('admin.modules.faculty.addedit')->with('faculty', $faculty);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Faculty $faculty)
    {
        $request = $this->stripHtmlTags($request, Faculty::$notStripTags);
        $id = $faculty->id;
        $rules = [
                    'name' => 'required|max:100',
                    'email' => 'required|email|regex:/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/',
                    'status' => 'required',
                    // 'image' => 'required',
                    'profile_url' => 'nullable|url',
                    'display_order'=>'nullable|integer|min:1'
                ];

        // Set Error Messages
        $messages = [
            // 'image.required' => 'The image field is required.',
        ];

        $this->validate($request, $rules, $messages);

        // Prepare Data Array
        $data = $request->all();

        // Save the Data
        $faculty->fill($data);
        $faculty->save();

        if ($request->get('btnsave') == 'savecontinue') {
            return redirect()->back()->with("success", __('faculty.update_success', ['name'=>$request->get('name'), 'last_name'=>$request->get('last_name')]));
        } elseif ($request->get('btnsave') == 'save') {
            return redirect()->route($this->indexRoute)->with("success", __('faculty.update_success', ['name'=>$request->get('name')]));
        } else {
            return redirect()->route($this->indexRoute);
        }
    }

    /**
     * Apply bulk action on selected items
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function bulkaction(Request $request)
    {
        $faculty = new Faculty();

        if ($request->get('bulk-action') == 'active') {
            Faculty::whereIn('id', $request->get('id'))->update(['status' => 1]);
            $message = __('faculty.active_success');
        } elseif ($request->get('bulk-action') == 'inactive') {
            $message = __('faculty.inactive_success');
            Faculty::whereIn('id', $request->get('id'))->update(['status' => 0]);
        } elseif ($request->get('bulk-action') == 'delete') {
            $needVerify = false;
            foreach ($request->get('id') as $pageId) {
                $faculty = Faculty::findOrFail($pageId);
                Faculty::destroy($pageId);

                PodcastRefSpeakers::where('speaker_id', $pageId)->delete();
            }
            if (!$needVerify) {
                $message = __('faculty.delete_success');
            } else {
                $message = __('faculty.delete_success_validate');
            }
        }
        $faculty::flushCache($faculty);
        event(new BulkAction($faculty->getTable(), $request->get('id'), $request->get('bulk-action')));
        return redirect()->back()->with('success', $message);
    }
    /**
     * Apply change status
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function changestatus(Request $request)
    {
        $faculty = Faculty::findOrFail($request->id);
        $faculty->status = $faculty->status == 1?0:1;
        $faculty->save();
        $message = displayMessages('faculty', $faculty->status);
        return redirect()->back()->with('success', $message);
    }
}
