<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Firm;
use App\User;
use App\State;
use Illuminate\Validation\Rule;
use App\Notifications\UserVerification;
use App\Events\BulkAction;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

class FirmController extends Controller
{
    protected $indexRoute = 'firm.index';
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $firm = new Firm;
        $firm = $firm->getResult($request);
        // Render view
        return view('admin.modules.firm.index')->with('firms', $firm);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $firm = new Firm;
        $data = $this->getFirmPageData($firm);
        return view('admin.modules.firm.addedit')->with($data);
    }

    function generateUniqueCode($length = 4)
    {
        $code = strtolower(Str::random($length));

        // Check if the code is unique in the database
        while (Firm::where('code', $code)->exists()) {
            $code = strtolower(Str::random($length));
        }

        return $code;
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse 
     */
    public function store(Request $request, Firm $firm)
    {
        $request = $this->stripHtmlTags($request, Firm::$notStripTags);
        $this->validation($request);
        $data = $request->all();
        $data['code'] = $this->generateUniqueCode();
        $user = User::where('email', $request->get('email'))->first();
        $userdata['user_type_id'] = 2;
        $userdata['first_name'] = $data['adminname'];
        $userdata['email'] = $data['email'];
        $userdata['phone'] = $data['adminphone'];
        unset($data['adminname']);
        unset($data['email']);
        unset($data['adminphone']);
        if (!empty($user->id)) {
            // Restore user account if already exist
            $user->restore();
            // Update user data.
            $userdata['deleted_at'] = null;
            $userdata['password'] = null;
            $userdata['email_verified_at'] = null;
            $userdata['status'] = 0;
            if(isset($userdata['birthdate']) && !empty($userdata['birthdate'])){
                $userdata['birthdate'] = Carbon::parse($userdata['birthdate'])->format('Y-m-d');
            }
            $user->fill($userdata);
            $user->save();
            $message = 'user.restored_success';
        } else {
            // Save the User Data
            $user = new User;
            if(isset($userdata['birthdate']) && !empty($userdata['birthdate'])){
                $userdata['birthdate'] = Carbon::parse($userdata['birthdate'])->format('Y-m-d');
            }
            $user->fill($userdata);
            $user->save();
        }

        // Generate Reset Password Token
        $token = app(\Illuminate\Auth\Passwords\PasswordBroker::class)->createToken($user);
        $user->remember_token = $token;
        $user->save();
        // Send Verification Email to User.
        $user->notify(new UserVerification($token));

        $data['user_id'] = $user->id;
        $data['status'] = 0;
        $firm->fill($data);
        $firm->save();


        if ($request->get('btnsave') == 'savecontinue') {
            return redirect()->route('firm.edit', ['firm' => $firm->id])->with("success", __('firm.create_success', ['name' => $request->get('name')]));
        } elseif ($request->get('btnsave') == 'save') {
            return redirect()->route($this->indexRoute)->with("success", __('firm.create_success', ['name' => $request->get('name')]));
        } else {
            return redirect()->route($this->indexRoute);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Firm  $firm
     * @return \Illuminate\Http\Response
     */
    public function show(Firm $firm)
    {
        $data = $this->getFirmPageData($firm);
        return view('admin.modules.firm.view')->with($data);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Firm  $firm
     * @return \Illuminate\Http\Response
     */
    public function edit(Firm $firm)
    {
        $data = $this->getFirmPageData($firm);
        return view('admin.modules.firm.addedit')->with($data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Firm  $firm
     * @return \Illuminate\Http\RedirectResponse 
     */
    public function update(Request $request, Firm $firm)
    {
        $request = $this->stripHtmlTags($request, Firm::$notStripTags);
        $this->validation($request,$firm->user_id);
        $validate = 'yes';
        $data = $request->all();

        $user = User::find($firm->user_id);
        $validate = 'yes';
        if ($user->email_verified_at == null) {
            if (isset($data['status']) && !empty($data['status']) &&  $data['status'] == 1) {
                $validate = 'not';
            }
            unset($data['status']);
        }
        $userdata['first_name'] = $data['adminname'];
        $userdata['phone'] = $data['adminphone'];
        $user->fill($userdata);
        $user->save();

        unset($data['adminname']);
        unset($data['email']);
        unset($data['adminphone']);
        unset($data['code']);
        $firm->sameasfirm = 0;
        $firm->fill($data);
        $firm->save();

        $firmUsers = $firm->firmUsers()->pluck('id');
        if ($data['status']  == 0) {
            Firm::where('id', $request->id)->update(['status' => 0]);
            User::where('id', $firm->user_id)->update(['status' => 0]);
            User::whereIn('id',$firmUsers)->update(['status' => 0]);
        }

        $message = __('firm.update_success', ['name' => $request->get('name')]);

        if ($request->get('btnsave') == 'savecontinue') {
            return redirect()->route('firm.edit', ['firm' => $firm->id])->with("success", $message);
        } elseif ($request->get('btnsave') == 'save') {
            return redirect()->route($this->indexRoute)->with("success", $message);
        } else {
            return redirect()->route($this->indexRoute);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Firm  $firm
     */
    public function destroy(Firm $firm)
    {
        //
    }
     /**
     * Validate the Form
     *
     * @param  \Illuminate\Http\Request  $request
     */
    private function validation($request, $userid = 0)
    {
        $rules = [
            'name' => 'required',
            'adminname' => 'required',
            'adminphone' => ['required','min:10'],
            'address1' => 'required',
            'city' => 'required',
            'state_id' => 'required',
            'zipcode' => ['required', 'regex:/^\d{5}$/'],
            'billing_name' => 'required',
            'billing_email' => 'required',
            'billing_address1' => 'required',
            'billing_city' => 'required',
            'billing_state_id' => 'required',
            'billing_zipcode' => ['required', 'regex:/^\d{5}$/'],
            'user_subscription' => 'required',
            'firm_size' => 'required'
        ];

        if($userid > 0){
        }else{
            $rules['email'] = ['required', 'email:rfc,dns', Rule::unique('users')->whereNull('deleted_at')];
        }

        $messages = [
            'name.required' => 'The firm name field is required',
            'adminname.required' => 'The admin name field is required.',
            'email.required' => 'The admin email field is required.',
            'adminphone.required' => 'The admin phone field is required.',
            'adminphone.min' => ' The admin phone number must be 10 characters. ',
            'zipcode.regex' => 'The zipcode does not match the format. eg. 12345',
            'billing_zipcode.regex' => 'The billing zipcode does not match the format. eg. 12345',
        ];

        $this->validate($request, $rules, $messages);
    }
    /**
     * Apply change visible
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse 
     */
    public function changestatus(Request $request)
    {
        $firm = Firm::findOrFail($request->id);
        $firmUsers = $firm->firmUsers()->pluck('id');
        if ($firm->status  == 0) {
           $validate = 'yes';
            if ($firm->firmadmin->email_verified_at == null) {
                    $validate = 'not';
            }
            else{
                Firm::where('id', $request->id)->update(['status' => 1]);
                User::where('id', $firm->user_id)->update(['status' => 1]);
                User::whereIn('id',$firmUsers)->update(['status' => 1]);
            }
            if ($validate == 'yes') {
                $message = __('firm.record_active_success');
            } else {
                $message = __('firm.record_active_success_validate');
            }
        }else{
            User::where('id', $firm->user_id)->update(['status' => 0]);
            Firm::where('id', $request->id)->update(['status' => 0]);
            User::whereIn('id',$firmUsers)->update(['status' => 0]);
            $message = displayMessages('firm', 0);
        }
        return redirect()->back()->with('success', $message);
    }

    /**
     * Apply bulk action on selected items
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse 
     */
    public function bulkAction(Request $request)
    {
        $firm = new Firm();

        if ($request->get('bulk-action') == 'active') {
            $needVerify = false;
            foreach ($request->get('id') as $firmID) {
                $firm = Firm::findOrFail($firmID);
                $firmUsers = $firm->firmUsers()->pluck('id');
                if ($firm->firmadmin->email_verified_at == null) {
                    $needVerify = true;
                }
                else{
                    Firm::where('id', $firmID)->update(['status' => 1]);
                    User::where('id', $firm->user_id)->update(['status' => 1]);
                    User::whereIn('id',$firmUsers)->update(['status' => 1]);
                }
            }
            if (!$needVerify) {
                $message = __('firm.active_success');
            } else {
                $message = __('firm.active_success_validate');
            }
        } elseif ($request->get('bulk-action') == 'inactive') {
            $needVerify = false;

            foreach ($request->get('id') as $firmID) {
                $firm = Firm::findOrFail($firmID);
                $firmUsers = $firm->firmUsers()->pluck('id');
                Firm::where('id', $firmID)->update(['status' => 0]);
                User::where('id', $firm->user_id)->update(['status' => 0]);
                User::whereIn('id',$firmUsers)->update(['status' => 0]);
            }

            $message = __('firm.inactive_success');
        } elseif ($request->get('bulk-action') == 'delete') {
            foreach ($request->get('id') as $firmID) {
                $firm = Firm::findOrFail($firmID);
                $needVerify = false;
                $firm->firmadmin->delete();
                Firm::destroy($firmID);
            }
            if (!$needVerify) {
                $message = __('firm.delete_success');
            } else {
                $message = __('firm.delete_success_validate');
            }
        }
        $firm::flushCache($firm);
        event(new BulkAction($firm->getTable(), $request->get('id'), $request->get('bulk-action')));
        return redirect()->back()->with('success', $message);
    }

    public function getFirmPageData($firm){

        if(isset($firm->user_id) && !empty($firm->user_id)){
            $firmadmin = User::find($firm->user_id);
            $firm->adminname = $firmadmin->first_name;
            $firm->email = $firmadmin->email;
            $firm->adminphone = $firmadmin->phone;
        }
        $data['firm'] = $firm;
        $data['states'] = State::all();
        return $data;
    }
}
