<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\User;
use App\IpTracker;
use App\Http\Controllers\Controller;

class IpTrackerController extends Controller
{
    
    /**
     * Display a listing of the resource.
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $ip = new IpTracker;
        $ips = $ip->getResult($request);
        $visibleColumns = IpTracker::$visibleColumns;
        $users = new User;
        $userType = $users->getAssociateType();
        // Render view
        return view('admin.modules.iptracker.index')->with(['iptrackers' => $ips, 'visibleColumns'=> $visibleColumns, 'usertype' => $userType]);
    }

    /**
     * Pagination call
     *  @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\ResponseJson
     */
    public function getMoreData(Request $request)
    {
        $ip = new IpTracker;
        $requestData = $request->all();

        $visibleColumns = IpTracker::$visibleColumns;

        $ips = $ip->getResult($request);
        $totalData = count($ip->getResult($request,'no'));
        
        $json_data = array(
            "draw" => intval($requestData['draw']),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalData),
            "data" => $ips   // total data array
        );
        // Render view
        return response()->json($json_data);
    }
}
