<?php

namespace App\Http\Controllers\Admin;

use App\Events\BulkAction;
use App\Member;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class MemberController extends Controller
{
    protected $indexRoute = 'members.index';
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $members = new Member;
        $members = $members->getResult($request);

        // Render view
        return view('admin.modules.members.index')->with('members', $members);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $member = new Member();
        return view('admin.modules.members.addedit')->with('member', $member);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, Member $member)
    {
        $request = $this->stripHtmlTags($request, Member::$notStripTags);
        $rules = [
            'name' => 'required|max:100',
            'status' => 'required',
            'description' => 'required',
            // 'image' => 'required',
        ];

        $messages = [
            // 'image.required' => 'The image field is required.',
            'description.required' => 'The member description field is required.',
            'name.required' => 'The name field is required.'
        ];

        $this->validate($request, $rules, $messages);

        // Prepare Data Array
        $data = $request->all();

        // Save the Data
        $member->fill($data);
        $member->save();

        if ($request->get('btnsave') == 'savecontinue') {
            return redirect()->route('member.edit', ['member' => $member->id])->with("success", __('member.create_success', ['name'=>$request->get('name')]));
        } elseif ($request->get('btnsave') == 'save') {
            return redirect()->route($this->indexRoute)->with("success", __('member.create_success', ['name'=>$request->get('name')]));
        } else {
            return redirect()->route($this->indexRoute);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $member = Member::where('id', $id)->where('status', 1)->firstOrFail();
        return view('admin.modules.members.index')->with('member', $member);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Member $member)
    {
        return view('admin.modules.members.addedit')->with('member', $member);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Member $member)
    {
        $request = $this->stripHtmlTags($request, Member::$notStripTags);
        $id = $member->id;
        $rules = [
                    'name' => 'required|max:100',
                    'status' => 'required',
                    'description' => 'required',
                    // 'image' => 'required',
                ];

        // Set Error Messages
        $messages = [
            // 'image.required' => 'The image field is required.',
            'description.required' => 'The description field is required.',
        ];

        $this->validate($request, $rules, $messages);

        // Prepare Data Array
        $data = $request->all();

        // Save the Data
        $member->fill($data);
        $member->save();

        if ($request->get('btnsave') == 'savecontinue') {
            return redirect()->back()->with("success", __('member.update_success', ['name'=>$request->get('name'), 'last_name'=>$request->get('last_name')]));
        } elseif ($request->get('btnsave') == 'save') {
            return redirect()->route($this->indexRoute)->with("success", __('member.update_success', ['name'=>$request->get('name')]));
        } else {
            return redirect()->route($this->indexRoute);
        }
    }

    /**
     * Apply bulk action on selected items
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function bulkaction(Request $request)
    {
        $member = new Member();

        if ($request->get('bulk-action') == 'active') {
            Member::whereIn('id', $request->get('id'))->update(['status' => 1]);
            $message = __('member.active_success');
        } elseif ($request->get('bulk-action') == 'inactive') {
            $message = __('member.inactive_success');
            Member::whereIn('id', $request->get('id'))->update(['status' => 0]);
        } elseif ($request->get('bulk-action') == 'delete') {
            $needVerify = false;
            foreach ($request->get('id') as $pageId) {
                $member = Member::findOrFail($pageId);
                Member::destroy($pageId);
            }
            if (!$needVerify) {
                $message = __('member.delete_success');
            } else {
                $message = __('member.delete_success_validate');
            }
        }
        $member::flushCache($member);
        event(new BulkAction($member->getTable(), $request->get('id'), $request->get('bulk-action')));
        return redirect()->back()->with('success', $message);
    }
    /**
     * Apply change status
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function changestatus(Request $request)
    {
        $member = Member::findOrFail($request->id);
        $member->status = $member->status == 1?0:1;
        $member->save();
        $message = displayMessages('member', $member->status);
        return redirect()->back()->with('success', $message);
    }
}
