<?php

namespace App\Http\Controllers\Admin;

use App\Events\BulkAction;
use App\News;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class NewsController extends Controller
{
    protected $indexRoute = 'news.index';
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $news = new News;
        $news = $news->getResult($request);

        // Render view
        return view('admin.modules.news.index')->with('news', $news);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $news = new News();
        return view('admin.modules.news.addedit')->with('news', $news);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, News $news)
    {
        $request = $this->stripHtmlTags($request, News::$notStripTags);
        $rules = [
            'title' => 'required|max:100',
            'status' => 'required',
            'description' => 'required',
            'author' => 'nullable',
            // 'banner' => 'required',
        ];

        $messages = [
            // 'banner.required' => 'The banner field is required.',
            'description.required' => 'The news content field is required.',
        ];

        $this->validate($request, $rules, $messages);

        $title = $request->get('title');
        // For unqiue slug- To create the auto slug
        $slug = getSlugText($title, $news);

        // Prepare Data Array
        $data = $request->all();
        $data['slug'] = $slug;
        $data['banner'] = $request->get('banner');
    
        // Save the Data
        $news->fill($data);
        $news->save();

        if ($request->get('btnsave') == 'savecontinue') {
            return redirect()->route('news.edit', ['news' => $news->id])->with("success", __('news.create_success', ['title'=>$request->get('title')]));
        } elseif ($request->get('btnsave') == 'save') {
            return redirect()->route($this->indexRoute)->with("success", __('news.create_success', ['title'=>$request->get('title')]));
        } else {
            return redirect()->route($this->indexRoute);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $news = News::where('id', $id)->where('status', 1)->firstOrFail();
        return view('admin.modules.news.index')->with('news', $news);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(News $news)
    {
        return view('admin.modules.news.addedit')->with('news', $news);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, News $news)
    {
        $request = $this->stripHtmlTags($request, News::$notStripTags);
        $id = $news->id;
        $rules = [
                    'title' => 'required|max:100',
                    'slug' =>  "required|unique:news,slug,{$id},id,deleted_at,NULL",
                    'status' => 'required',
                    'description' => 'required',
                    // 'banner' => 'required',
                    'author' => 'nullable'
                ];

        // Set Error Messages
        $messages = [
            // 'banner.required' => 'The banner field is required when has banner is filled.',
            'description.required' => 'The news content field is required.',
        ];

        $this->validate($request, $rules, $messages);

        // Prepare Data Array
        $data = $request->all();
        $data['banner'] = $request->get('banner');
        
        unset($data['slug']);
        // Save the Data
        $news->fill($data);
        $news->save();

        if ($request->get('btnsave') == 'savecontinue') {
            return redirect()->back()->with("success", __('news.update_success', ['title'=>$request->get('title'), 'last_name'=>$request->get('last_name')]));
        } elseif ($request->get('btnsave') == 'save') {
            return redirect()->route($this->indexRoute)->with("success", __('news.update_success', ['title'=>$request->get('title')]));
        } else {
            return redirect()->route($this->indexRoute);
        }
    }
    /**
     * Apply bulk action on selected items
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function bulkaction(Request $request)
    {
        $news = new News();

        if ($request->get('bulk-action') == 'active') {
            News::whereIn('id', $request->get('id'))->update(['status' => 1]);
            $message = __('news.active_success');
        } elseif ($request->get('bulk-action') == 'inactive') {
            $message = __('news.inactive_success');
            News::whereIn('id', $request->get('id'))->update(['status' => 0]);
        } elseif ($request->get('bulk-action') == 'delete') {
            $needVerify = false;
            foreach ($request->get('id') as $newsId) {
                $news = News::findOrFail($newsId);
                News::destroy($newsId);
            }
            if (!$needVerify) {
                $message = __('news.delete_success');
            } else {
                $message = __('news.delete_success_validate');
            }
        }
        $news::flushCache($news);
        event(new BulkAction($news->getTable(), $request->get('id'), $request->get('bulk-action')));
        return redirect()->back()->with('success', $message);
    }
    /**
     * Apply change status
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function changestatus(Request $request)
    {
        $news = News::findOrFail($request->id);
        $news->status = $news->status == 1?0:1;
        $news->save();
        $message = displayMessages('news', $news->status);
        return redirect()->back()->with('success', $message);
    }
}
