<?php

namespace App\Http\Controllers\Admin;

use App\ContentFiles;
use App\Events\BulkAction;
use App\Http\Controllers\Controller;
use App\PodcastStatistics;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Symfony\Component\HttpFoundation\StreamedResponse;

class PodcastStatisticsController extends Controller
{
    protected $indexRoute = 'podcaststatistics.index';
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $podcaststatistics = new PodcastStatistics();
        $podcaststatistics = $podcaststatistics->getResult($request);

        // Render view
        return view('admin.modules.podcaststatistics.index')->with('podcaststatistics', $podcaststatistics);
    }
    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $stats = PodcastStatistics::where('id', $id)->firstOrFail();
        return view('admin.modules.podcaststatistics.show')->with('podcast', $stats);
    }

    public function getMoreData(Request $request)
    {
        $podcast = new PodcastStatistics();
        $requestData = $request->all();

        // $visibleColumns = PodcastStatistics::$visibleColumns;

        $podcasts = $podcast->getResult($request);
        $totalData = count($podcast->getResult($request));
        
        $json_data = array(
            "draw" => intval($requestData['draw']),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalData),
            "data" => $podcasts   // total data array
        );
        // Render view
        return response()->json($json_data);
    }
}
