<?php

namespace App\Http\Controllers\Admin;

use App\Firm;
use App\User;
use Auth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\License;
use App\Rules\CaseSensitiveExists;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;

class ProfileController extends Controller
{
    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\User $user
     * @return \Illuminate\Http\Response
     */
    public function edit()
    {
        $user = Auth::user();

        if ($this->apiUrl() !== false) {

            $user = Auth::user()->getProfile();
            return response()->json(['message' => '','user'=>$user]);
        }
        else{
            return view('admin.modules.profile.addedit')->with('user', $user);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\User $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $user = User::find(Auth::id());

        if ($this->apiUrl() !== false) {
            $rules = [
                'user_firm_zip' => ['nullable', 'regex:/^\d{5}$/'],
                'user_work_email' => 'nullable|email:rfc,dns' ,
                'firmcode' => ['nullable', new CaseSensitiveExists('firms', 'code')]
            ];
        }
        else{
            $rules = [
                'first_name' => 'required',
                'user_firm_zip' => ['nullable', 'regex:/^\d{5}$/'],
                'user_work_email' => 'nullable|email:rfc,dns' ,
                'firmcode' => ['nullable', new CaseSensitiveExists('firms', 'code')]
            ];
            if($request['phone'] !== null && $request->has('phone')) {
                $rules['phone'] = 'min:10';
            }
            if($user->user_type_id != 2){
                $rules['last_name'] = 'required';
            }
        }

        $this->validate($request, $rules);
        $data = $request->all();
        if(isset($data['birthdate']) && !empty($data['birthdate'])){
            $data['birthdate'] = Carbon::parse($data['birthdate'])->format('Y-m-d');
        }
        unset($data['email']);
        $data['is_completed_profile'] = 1;
        $user->fill($data);
        $user->save();

        if ($this->apiUrl() !== false) {

            if(!isset($user->firmcode)){
                $firmData = [
                    'name' => $data['user_firm_name']??"",
                    'address1' => $data['user_firm_address1']??Null,
                    'address2' => $data['user_firm_address2']??Null,
                    'city' => $data['user_firm_city']??Null,
                    'state_id' => $data['user_firm_state_id']??0,
                    'zipcode' => $data['user_firm_zip']??Null,
                ];
                Firm::updateOrCreate(
                    ['user_id' => $user->id],
                    $firmData
                );
            }

            $userProfileData = $user->getProfile();
            return response()->json( ['message' =>__('user.update_profile_success', ['first_name' => $userProfileData["first_name"], 'last_name' =>$userProfileData["last_name"]]),'user'=> $userProfileData]);
        }
        else{
            return redirect()->route('dashboard')->with("success", __('user.update_profile_success', ['first_name' => $user->first_name, 'last_name' => $user->last_name]));
        }
    }

    public function profileImageUpload(Request $request)
    {
        // Set max execution time to zero to avoid max execution time error.
        ini_set('max_execution_time', '0');

        $size = 20 * 1024;
        $folder = $request->get('folder', 'profile_image');

        $rules = ['file' => 'required|mimes:jpeg,png,jpg,gif|max:'.$size];

        $messages = [
            'file.mimes' => 'The uploaded image extension is invalid. Image must be file of type: JPEG/JPG/PNG/GIF',
            'file.max' => 'The file may not be greater than '.$request->post('size').' MB.'
        ];

        if($request->extension != 'undefined'){
            $messages['file.mimes'] = 'The uploaded '.$request->folder.' extension is invalid.<br/> '.ucfirst($request->folder).' must be file of type: '.str_replace(",","/",$request->extension);
        }
        $this->validate($request, $rules, $messages);


        $visibility = getMediaVisibility(config('image-sizes.'.$folder.'.visibility'));

        $file = request()->file('file');
        $file_extension = $file->getClientOriginalExtension();
        $file_name = hash("sha512",explode('.'.$file_extension, $file->getClientOriginalName())[0].time()).'.'.$file_extension;

        $storage_file = Storage::putFileAs($folder, request()->file('file'), $file_name, $visibility);
        $storage_file_url = getMediaUrl($storage_file, $visibility);

        // Generate Resized Images
        // foreach (config('image-sizes.'.$folder.'.sizes', []) as $prefix => $image) {
        //     $resizeFile = Image::make(request()->file('file'));

        //     switch ($image['method']) {

        //         case 'fit': {
        //             $resizeFile->resize($image['width'], $image['height'], function ($constraint) {
        //                 $constraint->aspectRatio();
        //             });
        //             break;
        //         }
        //         case 'crop':
        //         default:
        //         {
        //             $resizeFile->fit($image['width'], $image['height'])->crop($image['width'], $image['height']);
        //             break;
        //         }

        //     }
        //     $resizeFile->encode(null, config('image.quality'));
        //     Storage::put($folder."/".$prefix.'-'.$file_name, (string) $resizeFile, $visibility);

        // }


        $user = User::find(Auth::id())->update(['profile_image'=>$file_name]);
        return response()->json(['message'=>'Profile image upload successfully.','location' => $storage_file_url, 'file' => $file_name]);

    }

    function checkFirmApprovedStatus() {
        $user = User::find(Auth::user()->id);
        return response()->json(['message' => 'Status refreshed successfully', 'status' => $user->firm_approved_status]);
    }
}
