<?php

namespace App\Http\Controllers\Admin;

use App\Events\BulkAction;
use App\Releases;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ReleasesController extends Controller
{
    protected $indexRoute = 'releases.index';
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $releases = new Releases;
        $releases = $releases->getResult($request);

        // Render view
        return view('admin.modules.releases.index')->with('releases', $releases);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $releases = new Releases();
        return view('admin.modules.releases.addedit')->with('releases', $releases);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, Releases $releases)
    {
        $request = $this->stripHtmlTags($request, Releases::$notStripTags);
        $rules = [
            'name' => 'required|max:100',
            'status' => 'required',
            'description' => 'required',
            // 'image' => 'required',
        ];

        $messages = [
            // 'image.required' => 'The image field is required.',
            'description.required' => 'The releases content field is required.',
        ];

        $this->validate($request, $rules, $messages);
        // Prepare Data Array
        $data = $request->all();

        if($request->released_on){
            $inputDate = Carbon::parse($request->released_on);
            $data['released_on'] = $inputDate;
        }else{
            $data['released_on'] = Null;
        }
    
        // Save the Data
        $releases->fill($data);
        $releases->save();

        if ($request->get('btnsave') == 'savecontinue') {
            return redirect()->route('releases.edit', ['releases' => $releases->id])->with("success", __('releases.create_success', ['name'=>$request->get('name')]));
        } elseif ($request->get('btnsave') == 'save') {
            return redirect()->route($this->indexRoute)->with("success", __('releases.create_success', ['name'=>$request->get('name')]));
        } else {
            return redirect()->route($this->indexRoute);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $releases = Releases::where('id', $id)->where('status', 1)->firstOrFail();
        return view('admin.modules.releases.index')->with('releases', $releases);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Releases $release)
    {
        return view('admin.modules.releases.addedit')->with('releases', $release);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Releases $release)
    {
        $request = $this->stripHtmlTags($request, Releases::$notStripTags);
        $id = $release->id;
        $rules = [
                    'name' => 'required|max:100',
                    'status' => 'required',
                    'description' => 'required',
                    // 'image' => 'required',
                ];

        // Set Error Messages
        $messages = [
            // 'image.required' => 'The image field is required',
            'description.required' => 'The releases content field is required.',
        ];

        $this->validate($request, $rules, $messages);

        // Prepare Data Array
        $data = $request->all();

        if($request->released_on){
            $inputDate = Carbon::parse($request->released_on);
            $data['released_on'] = $inputDate;
        }else{
            $data['released_on'] = Null;
        }

        // Save the Data
        $release->fill($data);
        $release->save();

        if ($request->get('btnsave') == 'savecontinue') {
            return redirect()->back()->with("success", __('releases.update_success', ['name'=>$request->get('name'), 'last_name'=>$request->get('last_name')]));
        } elseif ($request->get('btnsave') == 'save') {
            return redirect()->route($this->indexRoute)->with("success", __('releases.update_success', ['name'=>$request->get('name')]));
        } else {
            return redirect()->route($this->indexRoute);
        }
    }
    /**
     * Apply bulk action on selected items
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function bulkaction(Request $request)
    {
        $releases = new Releases();

        if ($request->get('bulk-action') == 'active') {
            Releases::whereIn('id', $request->get('id'))->update(['status' => 1]);
            $message = __('releases.active_success');
        } elseif ($request->get('bulk-action') == 'inactive') {
            $message = __('releases.inactive_success');
            Releases::whereIn('id', $request->get('id'))->update(['status' => 0]);
        } elseif ($request->get('bulk-action') == 'delete') {
            $needVerify = false;
            foreach ($request->get('id') as $releasesId) {
                $releases = Releases::findOrFail($releasesId);
                Releases::destroy($releasesId);
            }
            if (!$needVerify) {
                $message = __('releases.delete_success');
            } else {
                $message = __('releases.delete_success_validate');
            }
        }
        $releases::flushCache($releases);
        event(new BulkAction($releases->getTable(), $request->get('id'), $request->get('bulk-action')));
        return redirect()->back()->with('success', $message);
    }
    /**
     * Apply change status
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function changestatus(Request $request)
    {
        $releases = Releases::findOrFail($request->id);
        $releases->status = $releases->status == 1?0:1;
        $releases->save();
        $message = displayMessages('releases', $releases->status);
        return redirect()->back()->with('success', $message);
    }
}
