<?php

namespace App\Http\Controllers\Admin;

use App\Events\BulkAction;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Validation\Rule;
use App\Http\Requests\UserFormValidation;
use App\User;
use App\UserType;

class RoleController extends Controller
{
    protected $roleUpdateMsg = 'role.update_success';
    /**
     * Display a listing of the resource.
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $roles = new UserType();
        $roles = $roles->getResult($request);
        // Render view
        return view('admin.modules.role.index')->with('roles', $roles);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\User $user
     * @return \Illuminate\Http\Response
     */
    public function edit(UserType $role)
    {
        return view('admin.modules.role.addedit')->with('role', $role);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\User $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, UserType $role)
    {
        $request = $this->stripHtmlTags($request, UserType::$notStripTags);
        $data = $request->all();
        $role->fill($data);
        $role->save();
        // Assign permission to the saved role
        $permission = isset($request->get('permission')[$role->id]) ? $request->get('permission')[$role->id] : [];
        UserType::find($role->id)->fill(['permission' => $permission])->save();

        if ($request->get('btnsave') == 'savecontinue') {
            return redirect()->back()->with("success", __($this->roleUpdateMsg, ['title' => $role->title]));
        } elseif ($request->get('btnsave') == 'save') {
            return redirect()->route('role.index')->with("success", __($this->roleUpdateMsg, ['title' => $role->title]));
        } else {
            return redirect()->route('role.index')->with("success", __($this->roleUpdateMsg, ['title' => $role->title]));
        }
    }


    /**
     * Apply bulk action on selected role
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function bulkaction(Request $request)
    {
        $userrole = new UserType();
        if ($request->get('bulk-action') == 'active') {
            UserType::whereIn('id', $request->get('id'))->update(['status' => 1]);
            $message = __('role.active_success');
        } elseif ($request->get('bulk-action') == 'inactive') {
            UserType::whereIn('id', $request->get('id'))->update(['status' => 0]);
            $message = __('role.inactive_success');
        }
        \Session::flash('success', $message);
        event(new BulkAction($userrole->getTable(), $request->get('id'), $request->get('bulk-action')));
        return redirect()->back();
    }

    /**
     * Apply change status
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function changestatus(Request $request)
    {
        $userrole = UserType::findOrFail($request->id);
        $userrole->status = ($userrole->status == 1) ? 0 : 1;
        $userrole->save();
        $message = displayMessages('role', $userrole->status);
        return redirect()->back()->with('success', $message);
    }
}
