<?php
namespace App\Http\Controllers\Admin;

use Illuminate\Support\Facades\Auth;
use Illuminate\Routing\Controller;
use Illuminate\Http\Request;
use App\User;

class SecurityCodeController extends Controller
{
    public function showForm()
    {
        if(Auth::user()->securitycode == ''){
            return redirect()->intended('/');
        }
        return view('admin.modules.auth.codeoption');
    }

    public function verify(Request $request)
    {
        $user = Auth::user();
        $securityCode = $request->input('security_code');
        
        if ($user && (int) $securityCode === (int) $user->securitycode) {
            $user->update(['securitycode' => '']);
            // Security code is correct, log in the user
            Auth::login($user);

            // Redirect the user to the desired location
            return redirect()->intended('/');
        }

        // Security code verification failed
        return back()->withErrors(['security_code' => 'Invalid security code'])->withInput();
    }

    public function clear(){
        $user = Auth::user();
        $user->update(['securitycode' => '']);
        Auth::logout();
        return redirect()->route('login');
    }

}
