<?php

namespace App\Http\Controllers\Admin;

use App\SiteConfig;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\SiteConfig as SiteConfigModel;

class SiteConfigController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @param  string $module
     * @return \Illuminate\Http\Response
     */
    public function index($module)
    {
        return view('admin.modules.siteconfig.index')->with('module', $module);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  string $module
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, $module)
    {
        $request = $this->stripHtmlTags($request, SiteConfig::$notStripTags);
        // Get validation rules
        $rules = SiteConfig::getValidationRules($module);
        // Set Error Messages
        $messages = [
            'contact_title.required' => 'The title field is required.',
            'contact_thank_you_message.required' => 'The thank you message field is required.',
            'our_team_title.required' => 'The title field is required.',
            'our_team_sub_title.required' => 'The sub title field is required.',
        ];

        $attributes = [
            'field_blog_per_page_display' => 'blog per page display'
        ];
        // Validate the request
        $data = $request->validate($rules, $messages, $attributes);
        // Get input key name
        $validSettings = array_keys($rules);

        // Save site config to DB
        foreach ($data as $key => $val) {
            if (in_array($key, $validSettings)) {
                SiteConfig::updateOrCreate(
                    ['name' => $key],
                    ['val' => $val, 'status' => 1, 'type' => SiteConfig::getDataType($key)]
                );
            }
        }

        return redirect()->back()->with('success', __('siteconfig.success'));
    }

    /**
     * Update the specified site config value.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $request->validate([
            'key' => 'required|string',
            'value' => 'required'
        ]);

        try {
            $config = SiteConfig::where('name', $request->key)->first();
            if ($config) {
                $config->val = $request->value;
                $config->save();
            } else {
                SiteConfig::create([
                    'name' => $request->key,
                    'val' => $request->value
                ]);
            }

            return response()->json(['success' => true]);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()], 500);
        }
    }
}
