<?php

namespace App\Http\Controllers\Admin;

use App\Bar;
use App\BarUserReference;
use App\Content;
use App\ContentsStates;
use App\Events\BulkAction;
use App\Exports\SubmissionExport;
use App\Firm;
use App\Http\Controllers\Controller;
use App\Notifications\SendApprovedSubmissions;
use App\Notifications\SendCertificate;
use App\Submissions;
use App\Subscription;
use App\User;
use App\UserCredits;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Facades\Excel;
use stdClass;
use Carbon\Carbon;

class SubmissionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $submissions = new Submissions;
        $filterType = config('submission_filter');
        $keyValueFilterType = array_map(function ($index, $title) {
            return ['id' => $index + 1, 'title' => $title];
        }, array_keys($filterType), $filterType);


        $submissionsData = $submissions->getResult($request);

        $details= $this->submissionRecordManage($submissionsData);

        $firmList = Firm::where('status',1)->where('code','!=','')->pluck('name', 'code')->toArray();


        $resetLink = route('submissions.index', ['search' => '', 'type'=>5]);

        return view('admin.modules.submissions.index')->with(['submissions'=>$submissionsData, 'details'=>$details, 'filters'=>$keyValueFilterType, 'reset_link'=>$resetLink, 'type'=>1,'firmList'=>$firmList
    ]);
    }

    // bulk action
    public function bulkAction(Request $request)
    {

        $submissions = new Submissions();
        if ($request->get('bulk-action') == 'export') {
            $submissions->whereIn('id', $request->get('id'))->update(['status' => 1,'exported_at'=>Carbon::now()]);

            $submissionsData = $submissions->whereIn('id',$request->get('id'))->get();
            $details= $this->submissionRecordManage($submissionsData);
            $exportData = new SubmissionExport(collect($details)); // Convert array to collection
            $today = Carbon::now()->toDateString();
            $file_name = 'daily_report-' . $today.'_'.rand(). '.xlsx';
            return Excel::download($exportData, $file_name, null, [
                'Cache-Control' => 'no-cache, no-store, must-revalidate',
                'Pragma' => 'no-cache',
                'Expires' => '0',
            ]);
        }else if ($request->get('bulk-action') == 'submit') {
            $submissions->whereIn('id', $request->get('id'))->update(['status' => 2,'submitted_at'=>Carbon::now()]);
        }else if ($request->get('bulk-action') == 'approve') {
            $submissionIds = $request->get('id');
            $userId = Auth::user()->id;
            $user = User::findOrFail($userId);
            $submissions->whereIn('id', $submissionIds)->update(['status' => 4, 'approved_at' => Carbon::now(), 'approved_by'=>$userId]);
            
            $submissionsData = $submissions->whereIn('id', $submissionIds)->get();
            $details= $this->submissionRecordManage($submissionsData);
            $approved_credits = $submissionsData->count();
            $user->notify(new SendApprovedSubmissions(collect($details), $approved_credits));

        }else if ($request->get('bulk-action') == 'send certificate') {
            // Auth::user()->notify(new SendCertificate($pdfContent));
            // $submissions->whereIn('id', $request->get('id'))->update(['status' => 3,'certificated_at'=>Carbon::now()]);
        }

        // else if ($request->get('bulk-action') == 'submit and send certificate') {
        //     $submissions->whereIn('id', $request->get('id'))->update(['status' => 3,'certificated_at'=>Carbon::now(),'submitted_at'=>Carbon::now()]);
        // }
        $submissions::flushCache($submissions);
        event(new BulkAction($submissions->getTable(), $request->get('id'), $request->get('bulk-action')));

        return 1;
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    // submissions export

    // public function export()
    // {
    //     return Excel::download(new SubmissionExport, 'submissions.xlsx');
    // }



    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {

    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    function submissionRecordManage($submissionsData){
        $details = [];
        foreach ($submissionsData as $submission) {
            // Create a new stdClass object to store details
            $submissionDetails = new stdClass();

            // Set properties of the object
            $submissionDetails->general=0;
            $submissionDetails->ethics=0;
            $submissionDetails->dual=0;
            $submissionDetails->id = $submission->id;
            $submissionDetails->user_id = $submission->user_id;
            $submissionDetails->bar_id = $submission->bar_id;
            $submissionDetails->content_id = $submission->content_id;
            $submissionDetails->content_file_id = $submission->content_file_id;
            $submissionDetails->status = $submission->status;
            $submissionDetails->status_name = $submission->status_name;
            $submissionDetails->submitted_at = $submission->submitted_at;
            $submissionDetails->exported_at = $submission->exported_at;

            // get user bar id
            $submissionDetails->user_bar_id = $submission->getBarUserRefWhereBarId($submission->bar_id, $submission->user_id)->bar_number;

            // get user name
            $submissionDetails->user_name = $submissionDetails->user_name = $submission->user->getFullNameWhereId($submission->user_id);
            // get bar name
            $submissionDetails->state_name = $submission->getBarWhereId($submission->bar_id)->state_name;

            // get podcast bar id
            $submissionDetails->podcast_id_for_bar = $submissionDetails->podcast_id_for_bar = $submission->getContentStateWhereBarId($submission->bar_id,$submissionDetails->content_id)->state_bar_id;;

            // get podacst  name
            $submissionDetails->podcast_title = $submission->getContentWhereId($submissionDetails->content_id)->podcast_title;

            // get content upload/podcast bar_id
            $submissionDetails->podcast_bar_id = $submission->getContentFileWhereId($submissionDetails->content_file_id, $submissionDetails->content_id)->bar_id;

            if (Auth::user()->user_type_id == 1) {
                // get firm name in case of super admin
                $userFirmCode = User::select('firmcode')->where('id',$submissionDetails->user_id)->first()->firmcode;
                $submissionDetails->firm_name = Firm::select('name')->where('code', $userFirmCode)->first()->name;
            }

            // get credit submitted
            $submissionDetails->credits_submitted = $submission->credit_submitted;

            //get submitted date
            $submissionDetails->created_at = $submission->created_at;
            $submissionDetails->updated_at = $submission->updated_at;
            $submissionDetails->approved_at = $submission->approved_at;

            //get general/ethics/dual hours
            $submissionDetails->content_type = $submission->getContentWhereId($submissionDetails->content_id)->cl_type;
            if($submissionDetails->content_type == 1){
                $submissionDetails->general = $submissionDetails->credits_submitted;
            } elseif($submissionDetails->content_type == 2){
                $submissionDetails->ethics = $submissionDetails->credits_submitted;
            }else{
                $submissionDetails->dual = $submissionDetails->credits_submitted;
            }

            $details[] = $submissionDetails;

        }
        return $details;
    }


}
