<?php

namespace App\Http\Controllers\Admin;
use App\Bar;

use App\Firm;
use App\User;
use stdClass;
use App\Content;
use App\Subscription;
use App\ContentsStates;
use App\BarUserReference;
use App\Events\BulkAction;
use App\Exports\SubscriptionExport;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;

class SubscriptionsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $subscriptionModel = new Subscription;
        $subscriptionData = $subscriptionModel->getResult($request,1);
        $subscriptionAll = $subscriptionModel->getAll(1);

        // Initialize filters
        $namefilter = [];
        $barfilter = [];
        $statusfilter = config('subscription_status');
        $firmfilter = [];

        // Set filters
        foreach ($subscriptionAll as $subscription) {
            $user = $subscription->user;
            $bar = $subscription->bar;
            $firm = $user->appUserFirm;

            // Store unique names in namefilter array
            $name = $user->first_name . ' ' . $user->last_name;
            if (!isset($namefilter[$user->id])) {
                $namefilter[$user->id] = $name;
            }

            // Store unique bars in barfilter array
            if (!isset($barfilter[$bar->id])) {
                $barfilter[$bar->id] = $bar->state_name;
            }

            // Store unique firms in firmfilter array for super admins
            if (Auth::user()->user_type_id == 1 && $firm && !isset($firmfilter[$firm->code])) {
                $firmfilter[$firm->code] = $firm->name;
            }
        }

        $details = $subscriptionData->map(function($subscription) {
            $user = $subscription->user;
            $bar = $subscription->bar;
            $firm = $user->appUserFirm;

            return (object) [
                'id' => $subscription->id,
                'user_id' => $user->id,
                'bar_user_references_id' => $subscription->bar_user_references_id,
                'user_firstname' => $user->first_name,
                'user_lastname' => $user->last_name,
                'bar_name' => $bar->state_name,
                'stripe_subscription_status' => $subscription->stripe_subscription_status,
                'firm_name' => Auth::user()->user_type_id == 1 && $firm ? $firm->name : null,
                'start_date' => $subscription->start_date,
                'end_date' => $subscription->end_date,
                'cancel_at' => $subscription->cancel_at,
                'cancel_at_period_end' => $subscription->cancel_at_period_end,
                'status' => $subscription->status,
                'paid_by' => $subscription->barUserReference->paid_by,
            ];
        })->toArray();

        // Export data if requested
        if ($request->get('export')) {
            $export = new SubscriptionExport(collect($details));
            return Excel::download($export, 'subscriptions.xlsx');
        }

        $resetLink = route('subscriptions.index', ['search' => '']);

        // Render view
        return view('admin.modules.subscriptions.index', [
            'subscriptions' => $subscriptionData,
            'details' => $details,
            'reset_link' => $resetLink,
            'namefilter' => $namefilter,
            'barfilter' => $barfilter,
            'statusfilter' => $statusfilter,
            'firmfilter' => $firmfilter
        ]);
    }


    public function bulkAction(Request $request)
    {
        $subscriptions = new Subscription();

        if ($request->get('bulk-action') == 'delete') {

            Subscription::destroy($request->get('id'));

            $message = __('subscriptions-us.delete_success');
        }
        $subscriptions::flushCache($subscriptions);
        event(new BulkAction($subscriptions->getTable(), $request->get('id'), $request->get('bulk-action')));
        return redirect()->back()->with('success', $message);
    }


    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
