<?php

namespace App\Http\Controllers\Admin;

use App\Events\BulkAction;
use App\Support;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use App\Notifications\SupportNotification;
use Illuminate\Support\Facades\Notification;

class SupportController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $support = new Support;
        $supportData = $support->getResult($request);
        $resetLink = route('support.index', ['search' => '']);
        // Render view
        return view('admin.modules.support.index')->with('supportData', $supportData)->with('reset_link',$resetLink);
    }

    public function bulkAction(Request $request)
    {
        $support = new Support();

        if ($request->get('bulk-action') == 'delete') {

            Support::destroy($request->get('id'));

            $message = __('support.delete_success');
        }
        $support::flushCache($support);
        event(new BulkAction($support->getTable(), $request->get('id'), $request->get('bulk-action')));
        return redirect()->back()->with('success', $message);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}