<?php

namespace App\Http\Controllers\Api\Auth;

use App\AppUserAuthorization;
use Illuminate\Support\Facades\Auth;
use Illuminate\Auth\Events;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Notifications\IosActiveSubscription;
use Laravel\Passport\Passport;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Contracts\Cache\Repository as Cache;
use App\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Notification;
use Laravel\Passport\Token;

use function PHPUnit\Framework\isEmpty;

class ApiLoginController extends Controller
{
    use AuthenticatesUsers;

    /**
     * Handle a login request to the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\Response|\Illuminate\Http\JsonResponse
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function login(Request $request)
    {
        $this->validateLogin($request);

        $user = User::where('email', $request->email)->first();
        if (isset($user) && $user->status == 0 && $user->user_type_id != 1) {
            $message = 'Your account is not active, please activate your account by clicking on the ACTIVATION LINK sent to your email address ' . $user->email;
            return response()->json(['message' => $message], 201);
        }
        // If the class is using the ThrottlesLogins trait, we can automatically throttle
        // the login attempts for this application. We'll key this by the username and
        // the IP address of the client making these requests into this application.
        $device_type = $request->header('device-type');
        if(isset($user) && $device_type == 'ios'){
            $user_bars=$user->getUserBars();
            // Log::info($user_bars);
            if($user->is_completed_profile){
                foreach($user_bars as $ub){
                    $user_subscriptions = $user->getActiveSubscription($ub->bar_id);
                    if(!$user_subscriptions){
                        Notification::sendNow($user, new IosActiveSubscription());
                        return response()->json(['type'=>"User active subscription not found",'message' =>'You\'re only a few steps away from accessing CLE Podcasts. Kindly check your registered email for more details.']);
                    }
                }
            }
            // else{
            //     Notification::sendNow($user, new IosActiveSubscription());
            //             return response()->json(['type'=>"User not selected bar or completed profile",'message' =>'You\'re only a few steps away from accessing CLE Podcasts. Kindly check your registered email for more details.']);
            // }
        }

        if (
            method_exists($this, 'hasTooManyLoginAttempts') &&
            $this->hasTooManyLoginAttempts($request)
        ) {
            $this->fireLockoutEvent($request);

            return $this->sendLockoutResponse($request);
        }

        if ($this->attemptLogin($request)) {
            Token::where('user_id', $user->id)->delete();
            return $this->sendLoginResponse($request);
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        $this->incrementLoginAttempts($request);

        return $this->sendFailedLoginResponse($request);
    }

    /**
     * Send the response after the user was authenticated.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    protected function sendLoginResponse(Request $request)
    {
        $request->session()->regenerate();
        $this->clearLoginAttempts($request);
        $response =  $this->guard()->user()->toArray();

        $client = Passport::client()->where('password_client', 1)->get();
        $client = $client->sortByDesc('updated_at')->first();

        $http = new \GuzzleHttp\Client();

        $tokenResponse = $http->post(env('APP_URL') . '/oauth/token', [
            'form_params' => [
                'grant_type'    => 'password',
                'client_id'     => $client->id,
                'client_secret' => $client->secret,
                'username' => $request->email,
                'password' => $request->password,
                'scope'         => '*',
            ],
        ]);

        $data = json_decode((string)$tokenResponse->getBody(), true);
        $response['access_token'] = $data['access_token'];
        $response['refresh_token'] = $data['refresh_token'];
        $response['expires_in'] = $data['expires_in'];

        $getProfile = $this->guard()->user()->getProfile();
        $response = $response + $getProfile;
        //remove reset password token
        app(\Illuminate\Auth\Passwords\PasswordBroker::class)->deleteToken($this->guard()->user());

        unset($response["securitycode"]);

        $device_type = $request->header('device-type');

        if ($device_type == 'web') {
        $existingRecords = AppUserAuthorization::where('user_id', $getProfile['id'])->get();
            if ($existingRecords->isNotEmpty()) {
                // Update all records with the latest device_token
                AppUserAuthorization::where('user_id', $getProfile['id'])->update([
                    'device_token' => NULL,
                ]);
            }
        }

        return $this->authenticated($request, $this->guard()->user()) ?: response()->json(['message' => trans("Login Successfully."), 'user' => $response]);
    }

    /**
     * Get the needed authorization credentials from the request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    protected function credentials(Request $request)
    {
        return [$this->username() => $request->{$this->username()}, 'password' => $request->password, 'user_type_id' => 3, 'status' => 1];
    }

    /**
     * Logout user (Revoke the token)
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function logout(Request $request)
    {
        event(new Events\Logout(Auth::guard(), Auth::user()));
        $existingRecords = AppUserAuthorization::where('user_id', $request->user()->token()->user_id)->get();

        if ($existingRecords->isNotEmpty()) {
            // Update all records with the latest device_token
            AppUserAuthorization::where('user_id', $request->user()->token()->user_id)->update([
                'device_token' => NULL,
            ]);
        }
        $request->user()->token()->revoke();
        return response()->json(['message' => trans("Logout Successfully.")]);
    }
}
