<?php

namespace App\Http\Controllers\Api\v1;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Bar;
use App\User;
use App\State;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class BarController extends Controller
{
    protected $indexRoute = 'bar.index';

    public function getActiveBar(Request $request)
    {
        $bars = Bar::where('status',1)->whereNotNull('submission_fees_stripe_price_id')->whereNotNull('surcharge_fees_stripe_price_id')->whereNotNull('annual_price_stripe_price_id')->get();
        // Render view
        return response()->json( ["message"=> "Bars fetched successfully.",'data' => $bars]);
    }

    public function getBarPrice(Request $request)
    {
        
        $priceList = retrievePriceListOfUser(Auth::user()->id,$request->id,1);

        // checkout api response start
        $redirectRoute = "mobilePaySuccess";
        $promocodeId = siteconfig('stripe_discount_key') ? siteconfig('stripe_discount_key') : null;


        $user = Auth::user();
        if(!$user->stripe_customer_id){
            $stripe_customer_name = $user->fullName;
            if($user->user_type_id == 2){
                $stripe_customer_name = $user->firm->name." ( Firm )";
            }
            $customerRes = createStripeCustomer([
                'name'=>$stripe_customer_name,
                'email'=>$user->email
            ]);
            User::where('id', Auth::user()->id)->update([
                'stripe_customer_id' => $customerRes->id
            ]);
            Auth::user()->stripe_customer_id = $customerRes->id;
            $user = Auth::user();
        }else{
            $userSubscription = $user->subscriptions;
            $promocodeId = ($userSubscription->isEmpty()) ? $promocodeId : null ;
        }
        // Log::info('array',[$promocodeId,$userSubscription, $userSubscription->isEmpty()]);
        $redirectUrl = route($redirectRoute, ['user_id'=>Auth::user()->id,'session_id' => '{CHECKOUT_SESSION_ID}']);

        $link = createPaymentLink($priceList, $redirectUrl, Auth::user()->stripe_customer_id, $promocodeId);
        
        

        // checkout api response end

        $total_product_price = $link->amount_subtotal ?: 0;
        $total_discount = $link->total_details->amount_discount ?: 0;
        $finalTotalPrice = $link->amount_total ? $link->amount_total : $total_product_price;


        $finalTotalPriceDisplay = getPricePrefix(priceFormat(($finalTotalPrice/100)));
        $finalSubTotalPriceDisplay = getPricePrefix(priceFormat(($total_product_price/100)));
        $finalTotalDiscountDisplay = getPricePrefix(priceFormat(($total_discount/100)));
        $promocode = $link->total_details->amount_discount != 0 ? retrieveStripePromocode($link->discounts[0]->promotion_code) : null;
        $is_discount_percentage = $promocode != null ? ($promocode->coupon->percent_off == null ? 0 : 1) : 0 ;
        $discount_percentage = $promocode != null ?( $promocode->coupon->percent_off != null ? $promocode->coupon->percent_off : 0) : 0;
        $coupon_name = $promocode != null ? ($promocode->coupon->name) : null;

        $data = (object) array(
            'totalPrice'=>$finalTotalPrice,
            'totalSubTotal'=>$total_product_price,
            'totalDiscount'=>$total_discount,
            'checkoutLink'=>$link->url,
            'promocode'=>$coupon_name,
            'discount_percentage'=> $discount_percentage,
            'is_discount_percentage'=> $is_discount_percentage,
            'finalTotalPriceDisplay'=>$finalTotalPriceDisplay,
            'finalSubTotalPriceDisplay'=>$finalSubTotalPriceDisplay,
            'finalTotalDiscountDisplay'=>$finalTotalDiscountDisplay,
            'price_list'=>$priceList,
        );

        return response()->json( ["message"=> "Bar prices fetched successfully.",'data' => $data]);
    }

}
