<?php

namespace App\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use App\Submissions;
use App\Subscription;
use App\User;
use App\UserCredits;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

//Note : The MultipleSubmissionsController and the Api/v2/SubmissionController are same. We have created Api/v2/SubmissionController to perform versioning but it won't be of use until all the other APIs are converted to version 2 too. For now the api/v1/submission endpoint should not be used, we can handle submission single or multiple from api/v1/multiple-submission endpoint itself.

class MultipleSubmissionsController extends Controller
{
    public function sortRangesAscending($array) {
        // Sort the collection by the start values of credit_for in ascending order
        $sortedCollection = $array->sortBy(function ($item) {
            return explode('-', $item['credit_for'])[0];
        });

        return $sortedCollection;
    }
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, Submissions $submissions)
    {
        $results = [];

        try {
            $data = $request->all();
            $user = User::find(Auth::user()->id);
            $user_id = $user->id;

            $totalCredits = array_reduce($data, function ($carry, $item) {
                return $carry + $item['credit'];
            }, 0);
            $submitted_credit_sum = 0 ;

            foreach($data as $index => $submissionData){
                $data_bar_id = $submissionData['bar_id'];
                $data_file_id = $submissionData['file_id'];
                $data_state_id = $submissionData['state_id'];
                $data_credit = $submissionData['credit'];
                $data_content_id = $submissionData['content_id'];
                $data_video_credit = $submissionData['video_credit'];

                // get subscription to which credits are to be submitted
                $credit_subscription = $user->getActiveSubscription($data_bar_id);
                if (!$credit_subscription) {
                    throw new \Exception("Active subscription not found for Bar ID: $data_bar_id");
                }
                $credit_subscription_id = $credit_subscription->id;
                $credit_subscription_subs_id = $credit_subscription->subscription_id;
                $credit_subscription_bar_user_ref = $credit_subscription->bar_user_references_id;

                $credit_provided_by_the_course = $credit_subscription->hours_needed_per_cycle;
                $remaining_hours_needed_per_cycle = $credit_subscription->remaining_hours_needed_per_cycle;

                // $credit_provided_by_the_course = Bar::where("id", $data_bar_id)->first()->hours_needed_per_cycle;

                if (!$credit_provided_by_the_course) {
                    throw new \Exception("credit_provided_by_the_course not found");
                }

                $sortedRanges=[];

                $credit_submitted = $user->getCreditsSubmittedForBar($credit_subscription);

                $credits_remaining = max(0, $credit_subscription->remaining_hours_needed_per_cycle);


                $creditAvailableToSubmit= UserCredits::where("user_id", $user_id)
                ->where("content_id", $data_content_id)
                ->where("content_file_id", $data_file_id)
                ->where("content_state_id", $data_state_id)
                ->where("bar_id", $data_bar_id)
                ->where("submission_id", 0)
                ->sum('credit');

                if($creditAvailableToSubmit >= $data_credit){
                    if ($credits_remaining > 0) {
                        
                        if(($totalCredits-$submitted_credit_sum) > $credits_remaining){
                            $credit_diff = $data_credit - $credits_remaining;
                            $possible_credit_submission = $data_credit - $credit_diff;
                            $credit_left_after_submission = $credits_remaining - $possible_credit_submission;
        
                            $message = "You are currently left with {$credits_remaining} credits in your account. As a result, you will only be able to submit {$possible_credit_submission} with {$credit_left_after_submission} credits remaining.";
        
                            $results[] = [
                                'message' => $message, 
                                'status' => 4,
                                'totalCredits'=>$totalCredits
                            ];
                            // return response()->json(['message' => $message, 
                            //     'status' => 4,
                            //     'totalCredits'=>$totalCredits]);
                            break;
                        } else {
                            $data['user_id'] = $user_id;
                            $data['bar_id'] = $data_bar_id;
                            $data['content_id'] = $data_content_id;
                            $data['content_file_id'] = $data_file_id;
                            $data['content_state_id'] = $data_state_id;
                            $data['subscription_id'] = $credit_subscription_id;
                            $data['stripe_subscription_id'] = $credit_subscription_subs_id;

                            // check if user has already submitted any credits for this content
                            $previous_credit_submitted = $credit_submitted;
                                if($previous_credit_submitted != 0){
                                    // if($data_credit > $previous_credit_submitted){
                                    //     $new_credits_to_be_submitted = $data_credit-$previous_credit_submitted;
                                    // }else{
                                        $new_credits_to_be_submitted = $data_credit;
                                    // }
                                    // else{
                                    //     $new_credits_to_be_submitted = $previous_credit_submitted-$data_credit;
                                    // }
                                    $data['credit_submitted'] = $new_credits_to_be_submitted;
                                }else{
                                    $data['credit_submitted'] = $data_credit;
                                }

                            if($data['credit_submitted'] !=0){

                                $user_credits_sub= UserCredits::where("user_id", $user_id)
                                ->where("content_id", $data_content_id)
                                ->where("content_file_id", $data_file_id)
                                ->where("content_state_id", $data_state_id)
                                ->where("bar_id", $data_bar_id)
                                ->where("submission_id", 0)
                                ->get();

                                $user_credits_sum= $user_credits_sub->sum("credit");

                                $earned_credits =  $user_credits_sum;
                                if(($earned_credits == $data_video_credit) && ($data_credit < $earned_credits)){
                                    $results[] = [
                                        'message' => 'You are attempting to submit less credits than you have earned or credits have already been submitted.',
                                        'status' => 2,
                                        'totalCredits'=>$totalCredits
                                    ];
                                    // return response()->json([
                                    //     'message' => 'You are attempting to submit less credits than you have earned or credits have already been submitted.',
                                    //     'status' => 2
                                    // ]);
                                }

                                $submissions = new Submissions();
                                $submissions->fill($data);
                                $submissions->save();
                                // $submissions->fill($data);
                                // $submissions->save();

                                //create and send submission certification.
                                $submissionId = $submissions->id;

                                // update the subscriptions table remaining hours fields
                                // $credit_submitted = Submissions::where("user_id", $user_id)
                                // ->where("bar_id", $data_bar_id)
                                // ->where("subscription_id", $credit_subscription_id)
                                // ->where("stripe_subscription_id", $credit_subscription_subs_id)
                                // ->sum('credit_submitted');

                                $subscribed_credits_remaining = max(0, $remaining_hours_needed_per_cycle - $data_credit);

                                DB::table('subscriptions')
                                    ->where('id', $credit_subscription_id)
                                    ->update(['remaining_hours_needed_per_cycle' => $subscribed_credits_remaining]);

                                // add the submission id in the user_credits table
                                
                                if ($user_credits_sub) {
                                    $credits_remaining= $user_credits_sum - $data_credit;
                                    if($credits_remaining == 0){
                                        $sortedRanges = $this->sortRangesAscending($user_credits_sub);
                                        // Update the submission_id in user_credits
                                        DB::table('user_credits')
                                        ->whereIn('id', $sortedRanges->pluck('id'))
                                        ->update(['submission_id' => $submissionId]);
                                    }
                                }
                                $results[] = [
                                    'status' => 1,
                                    'message' => 'Submission data successfully saved.',
                                    'submissionId' => $submissionId,
                                    'totalCredits'=>$totalCredits,
                                ];

                                $submitted_credit_sum = $submitted_credit_sum + $data_credit;
                                // return response()->json(['message' => 'Submission data successfully saved.', 'status' => 1, 'user_id'=> $user_credits_sub]);
                            }else{
                                $results[] = [
                                    'status' => 4,
                                    'message' => 'Credits already submitted, please earn more credits to submit',
                                    'totalCredits'=>$totalCredits
                                ];
                                // return response()->json(['message' => 'Credits already submitted, please earn more credits to submit', 'status' => 4]);
                            }

                        }
                    } else {
                        $results[] = [
                            'message' => 'Your current subscription has been exhausted, and your access to credits has been temporarily suspended. To continue utilizing our services and accessing more credits, we kindly urge you to renew your subscription promptly.',
                            'status' => 3,
                            'bar_user_ref'=>$credit_subscription_bar_user_ref,
                            'subscription_id'=>$credit_subscription_id,
                            'totalCredits'=>$totalCredits
                        ];
                        // return response()->json([
                        //     'message' => 'Your current subscription has been exhausted, and your access to credits has been temporarily suspended. To continue utilizing our services and accessing more credits, we kindly urge you to renew your subscription promptly.',
                        //     'status' => 3,
                        //     'bar_user_ref'=>$credit_subscription_bar_user_ref,
                        //     'subscription_id'=>$credit_subscription_id
                        // ]);
                    }
                }else{
                    $results[] = [
                        'message' => 'You are attempting to submit more credits than you have or credits have already been submitted.',
                        'status' => 2,
                        'totalCredits'=>$totalCredits
                    ];
                    // return response()->json([
                    //     'message' => 'You are attempting to submit more credits than you have or credits have already been submitted.',
                    //     'status' => 2
                    // ]);
                }
            }
        } catch (\Exception $e) {
            return response()->json(['message' => $e->getMessage(), 'status' => 2]);
        }
        return response()->json(end($results));
    }

}
